# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "ZigbeeDevice.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.zigbee


# interface
class ZigbeeDevice(Interface):
    idlType = "zigbee.ZigbeeDevice:1.0.0"

    CLUSTER_BASIC = 0x0

    CLUSTER_POWER_CONFIGURATION = 0x1

    CLUSTER_RSSI = 0xb

    CLUSTER_CONTACT_CLOSURE = 0xf

    CLUSTER_TEMPERATURE = 0x402

    CLUSTER_HUMIDITY = 0x405

    # structure
    class MetaData(Structure):
        idlType = "zigbee.ZigbeeDevice.MetaData:1.0.0"
        elements = ["sourceId", "clusters", "preferredSlot"]

        def __init__(self, sourceId, clusters, preferredSlot):
            typecheck.is_int(sourceId, AssertionError)
            for x0 in clusters:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_int(preferredSlot, AssertionError)

            self.sourceId = sourceId
            self.clusters = clusters
            self.preferredSlot = preferredSlot

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sourceId = json['sourceId'],
                clusters = [x0 for x0 in json['clusters']],
                preferredSlot = json['preferredSlot'],
            )
            return obj

        def encode(self):
            json = {}
            json['sourceId'] = self.sourceId
            json['clusters'] = [x0 for x0 in self.clusters]
            json['preferredSlot'] = self.preferredSlot
            return json

    # structure
    class ClusterValue(Structure):
        idlType = "zigbee.ZigbeeDevice.ClusterValue:1.0.0"
        elements = ["id", "endpoint", "attribute", "timestamp", "value"]

        def __init__(self, id, endpoint, attribute, timestamp, value):
            typecheck.is_int(id, AssertionError)
            typecheck.is_int(endpoint, AssertionError)
            typecheck.is_int(attribute, AssertionError)
            typecheck.is_time(timestamp, AssertionError)
            typecheck.is_string(value, AssertionError)

            self.id = id
            self.endpoint = endpoint
            self.attribute = attribute
            self.timestamp = timestamp
            self.value = value

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                endpoint = json['endpoint'],
                attribute = json['attribute'],
                timestamp = raritan.rpc.Time.decode(json['timestamp']),
                value = json['value'],
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['endpoint'] = self.endpoint
            json['attribute'] = self.attribute
            json['timestamp'] = raritan.rpc.Time.encode(self.timestamp)
            json['value'] = self.value
            return json

    # value object
    class ClusterDataEvent(raritan.rpc.idl.Event):
        idlType = "zigbee.ZigbeeDevice.ClusterDataEvent:1.0.0"

        def __init__(self, value, source):
            super(raritan.rpc.zigbee.ZigbeeDevice.ClusterDataEvent, self).__init__(source)
            typecheck.is_struct(value, raritan.rpc.zigbee.ZigbeeDevice.ClusterValue, AssertionError)

            self.value = value

        def encode(self):
            json = super(raritan.rpc.zigbee.ZigbeeDevice.ClusterDataEvent, self).encode()
            json['value'] = raritan.rpc.zigbee.ZigbeeDevice.ClusterValue.encode(self.value)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                value = raritan.rpc.zigbee.ZigbeeDevice.ClusterValue.decode(json['value'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["value"]
            elements = elements + super(raritan.rpc.zigbee.ZigbeeDevice.ClusterDataEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.zigbee.ZigbeeDevice.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.zigbee.ZigbeeDevice.MetaData, DecodeException)
            return _ret_

    class _getClusterValues(Interface.Method):
        name = 'getClusterValues'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.zigbee.ZigbeeDevice.ClusterValue.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.zigbee.ZigbeeDevice.ClusterValue, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(ZigbeeDevice, self).__init__(target, agent)
        self.getMetaData = ZigbeeDevice._getMetaData(self)
        self.getClusterValues = ZigbeeDevice._getClusterValues(self)

#
# Section generated by IdlC from "ZigbeeManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.zigbee


# interface
class ZigbeeManager(Interface):
    idlType = "zigbee.ZigbeeManager:1.0.0"

    ERR_DEVICE_EXISTS = 1

    ERR_MAX_DEVICE_REACHED = 2

    ERR_DEVICE_NOT_FOUND = 3

    ERR_INVALID_PARAMS = 4

    ERR_INVALID_KEY = 5

    ERR_INVALID_CHANNEL = 6

    # enumeration
    class DongleState(Enumeration):
        idlType = "zigbee.ZigbeeManager.DongleState:1.0.0"
        values = ["NOT_INIT", "READY", "ERROR", "INIT_IN_PROGRESS", "FW_UPGRADE", "IN_MODEM_STATE"]

    DongleState.NOT_INIT = DongleState(0)
    DongleState.READY = DongleState(1)
    DongleState.ERROR = DongleState(2)
    DongleState.INIT_IN_PROGRESS = DongleState(3)
    DongleState.FW_UPGRADE = DongleState(4)
    DongleState.IN_MODEM_STATE = DongleState(5)

    # structure
    class MetaData(Structure):
        idlType = "zigbee.ZigbeeManager.MetaData:1.0.0"
        elements = ["firmwareVersion", "stackVersion"]

        def __init__(self, firmwareVersion, stackVersion):
            typecheck.is_string(firmwareVersion, AssertionError)
            typecheck.is_string(stackVersion, AssertionError)

            self.firmwareVersion = firmwareVersion
            self.stackVersion = stackVersion

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                firmwareVersion = json['firmwareVersion'],
                stackVersion = json['stackVersion'],
            )
            return obj

        def encode(self):
            json = {}
            json['firmwareVersion'] = self.firmwareVersion
            json['stackVersion'] = self.stackVersion
            return json

    # structure
    class Settings(Structure):
        idlType = "zigbee.ZigbeeManager.Settings:1.0.0"
        elements = ["channel"]

        def __init__(self, channel):
            typecheck.is_int(channel, AssertionError)

            self.channel = channel

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                channel = json['channel'],
            )
            return obj

        def encode(self):
            json = {}
            json['channel'] = self.channel
            return json

    # structure
    class DeviceRegistration(Structure):
        idlType = "zigbee.ZigbeeManager.DeviceRegistration:1.0.0"
        elements = ["sourceId", "key", "slot"]

        def __init__(self, sourceId, key, slot):
            typecheck.is_int(sourceId, AssertionError)
            typecheck.is_string(key, AssertionError)
            typecheck.is_int(slot, AssertionError)

            self.sourceId = sourceId
            self.key = key
            self.slot = slot

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sourceId = json['sourceId'],
                key = json['key'],
                slot = json['slot'],
            )
            return obj

        def encode(self):
            json = {}
            json['sourceId'] = self.sourceId
            json['key'] = self.key
            json['slot'] = self.slot
            return json

    # value object
    class DeviceEvent(raritan.rpc.idl.Event):
        idlType = "zigbee.ZigbeeManager.DeviceEvent:1.0.0"

        def __init__(self, sourceId, source):
            super(raritan.rpc.zigbee.ZigbeeManager.DeviceEvent, self).__init__(source)
            typecheck.is_int(sourceId, AssertionError)

            self.sourceId = sourceId

        def encode(self):
            json = super(raritan.rpc.zigbee.ZigbeeManager.DeviceEvent, self).encode()
            json['sourceId'] = self.sourceId
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                sourceId = json['sourceId'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["sourceId"]
            elements = elements + super(raritan.rpc.zigbee.ZigbeeManager.DeviceEvent, self).listElements()
            return elements

    # value object
    class DeviceAddedEvent(DeviceEvent):
        idlType = "zigbee.ZigbeeManager.DeviceAddedEvent:1.0.0"

        def __init__(self, sourceId, source):
            super(raritan.rpc.zigbee.ZigbeeManager.DeviceAddedEvent, self).__init__(sourceId, source)

        def encode(self):
            json = super(raritan.rpc.zigbee.ZigbeeManager.DeviceAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for zigbee.ZigbeeManager.DeviceEvent
                sourceId = json['sourceId'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.zigbee.ZigbeeManager.DeviceAddedEvent, self).listElements()
            return elements

    # value object
    class DeviceRemovedEvent(DeviceEvent):
        idlType = "zigbee.ZigbeeManager.DeviceRemovedEvent:1.0.0"

        def __init__(self, sourceId, source):
            super(raritan.rpc.zigbee.ZigbeeManager.DeviceRemovedEvent, self).__init__(sourceId, source)

        def encode(self):
            json = super(raritan.rpc.zigbee.ZigbeeManager.DeviceRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for zigbee.ZigbeeManager.DeviceEvent
                sourceId = json['sourceId'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.zigbee.ZigbeeManager.DeviceRemovedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.idl.Event):
        idlType = "zigbee.ZigbeeManager.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings, newSettings, source):
            super(raritan.rpc.zigbee.ZigbeeManager.SettingsChangedEvent, self).__init__(source)
            typecheck.is_struct(oldSettings, raritan.rpc.zigbee.ZigbeeManager.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.zigbee.ZigbeeManager.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.zigbee.ZigbeeManager.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.zigbee.ZigbeeManager.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.zigbee.ZigbeeManager.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.zigbee.ZigbeeManager.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.zigbee.ZigbeeManager.Settings.decode(json['newSettings'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.zigbee.ZigbeeManager.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class StateChangedEvent(raritan.rpc.idl.Event):
        idlType = "zigbee.ZigbeeManager.StateChangedEvent:1.0.0"

        def __init__(self, oldState, newState, source):
            super(raritan.rpc.zigbee.ZigbeeManager.StateChangedEvent, self).__init__(source)
            typecheck.is_enum(oldState, raritan.rpc.zigbee.ZigbeeManager.DongleState, AssertionError)
            typecheck.is_enum(newState, raritan.rpc.zigbee.ZigbeeManager.DongleState, AssertionError)

            self.oldState = oldState
            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.zigbee.ZigbeeManager.StateChangedEvent, self).encode()
            json['oldState'] = raritan.rpc.zigbee.ZigbeeManager.DongleState.encode(self.oldState)
            json['newState'] = raritan.rpc.zigbee.ZigbeeManager.DongleState.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldState = raritan.rpc.zigbee.ZigbeeManager.DongleState.decode(json['oldState']),
                newState = raritan.rpc.zigbee.ZigbeeManager.DongleState.decode(json['newState']),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldState", "newState"]
            elements = elements + super(raritan.rpc.zigbee.ZigbeeManager.StateChangedEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.zigbee.ZigbeeManager.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.zigbee.ZigbeeManager.MetaData, DecodeException)
            return _ret_

    class _getDongleState(Interface.Method):
        name = 'getDongleState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.zigbee.ZigbeeManager.DongleState.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.zigbee.ZigbeeManager.DongleState, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.zigbee.ZigbeeManager.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.zigbee.ZigbeeManager.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.zigbee.ZigbeeManager.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.zigbee.ZigbeeManager.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _addDevices(Interface.Method):
        name = 'addDevices'

        @staticmethod
        def encode(sensors):
            for x0 in sensors:
                typecheck.is_struct(x0, raritan.rpc.zigbee.ZigbeeManager.DeviceRegistration, AssertionError)
            args = {}
            args['sensors'] = [raritan.rpc.zigbee.ZigbeeManager.DeviceRegistration.encode(x0) for x0 in sensors]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_int(x0, DecodeException)
            return _ret_

    class _removeDevice(Interface.Method):
        name = 'removeDevice'

        @staticmethod
        def encode(sourceId):
            typecheck.is_int(sourceId, AssertionError)
            args = {}
            args['sourceId'] = sourceId
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getRegisteredDevices(Interface.Method):
        name = 'getRegisteredDevices'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.zigbee.ZigbeeDevice, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(ZigbeeManager, self).__init__(target, agent)
        self.getMetaData = ZigbeeManager._getMetaData(self)
        self.getDongleState = ZigbeeManager._getDongleState(self)
        self.getSettings = ZigbeeManager._getSettings(self)
        self.setSettings = ZigbeeManager._setSettings(self)
        self.addDevices = ZigbeeManager._addDevices(self)
        self.removeDevice = ZigbeeManager._removeDevice(self)
        self.getRegisteredDevices = ZigbeeManager._getRegisteredDevices(self)
