# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2023 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "DoorAccessControl.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.smartlock


# interface
class DoorAccessControl(Interface):
    idlType = "smartlock.DoorAccessControl:1.2.2"

    ERR_INVALID_SETTINGS = 1

    ERR_NO_SUCH_ID = 2

    ERR_MAX_RULES_REACHED = 3

    # structure
    class AbsoluteTimeCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_2.AbsoluteTimeCondition:1.0.0"
        elements = ["enabled", "validFrom", "validTill"]

        def __init__(self, enabled, validFrom, validTill):
            typecheck.is_bool(enabled, AssertionError)
            typecheck.is_time(validFrom, AssertionError)
            typecheck.is_time(validTill, AssertionError)

            self.enabled = enabled
            self.validFrom = validFrom
            self.validTill = validTill

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                enabled = json['enabled'],
                validFrom = raritan.rpc.Time.decode(json['validFrom']),
                validTill = raritan.rpc.Time.decode(json['validTill']),
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['validFrom'] = raritan.rpc.Time.encode(self.validFrom)
            json['validTill'] = raritan.rpc.Time.encode(self.validTill)
            return json

    # structure
    class PeriodicTimeCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_2.PeriodicTimeCondition:1.0.0"
        elements = ["enabled", "daysOfWeek", "fromHourOfDay", "tillHourOfDay", "fromMinuteOfHour", "tillMinuteOfHour"]

        def __init__(self, enabled, daysOfWeek, fromHourOfDay, tillHourOfDay, fromMinuteOfHour, tillMinuteOfHour):
            typecheck.is_bool(enabled, AssertionError)
            for x0 in daysOfWeek:
                typecheck.is_int(x0, AssertionError)
            typecheck.is_int(fromHourOfDay, AssertionError)
            typecheck.is_int(tillHourOfDay, AssertionError)
            typecheck.is_int(fromMinuteOfHour, AssertionError)
            typecheck.is_int(tillMinuteOfHour, AssertionError)

            self.enabled = enabled
            self.daysOfWeek = daysOfWeek
            self.fromHourOfDay = fromHourOfDay
            self.tillHourOfDay = tillHourOfDay
            self.fromMinuteOfHour = fromMinuteOfHour
            self.tillMinuteOfHour = tillMinuteOfHour

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                enabled = json['enabled'],
                daysOfWeek = [x0 for x0 in json['daysOfWeek']],
                fromHourOfDay = json['fromHourOfDay'],
                tillHourOfDay = json['tillHourOfDay'],
                fromMinuteOfHour = json['fromMinuteOfHour'],
                tillMinuteOfHour = json['tillMinuteOfHour'],
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['daysOfWeek'] = [x0 for x0 in self.daysOfWeek]
            json['fromHourOfDay'] = self.fromHourOfDay
            json['tillHourOfDay'] = self.tillHourOfDay
            json['fromMinuteOfHour'] = self.fromMinuteOfHour
            json['tillMinuteOfHour'] = self.tillMinuteOfHour
            return json

    # structure
    class CardReaderInfo(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_2.CardReaderInfo:1.0.0"
        elements = ["linkId", "position"]

        def __init__(self, linkId, position):
            typecheck.is_int(linkId, AssertionError)
            typecheck.is_string(position, AssertionError)

            self.linkId = linkId
            self.position = position

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                linkId = json['linkId'],
                position = json['position'],
            )
            return obj

        def encode(self):
            json = {}
            json['linkId'] = self.linkId
            json['position'] = self.position
            return json

    # structure
    class KeypadInfo(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_2.KeypadInfo:1.0.0"
        elements = ["linkId", "position"]

        def __init__(self, linkId, position):
            typecheck.is_int(linkId, AssertionError)
            typecheck.is_string(position, AssertionError)

            self.linkId = linkId
            self.position = position

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                linkId = json['linkId'],
                position = json['position'],
            )
            return obj

        def encode(self):
            json = {}
            json['linkId'] = self.linkId
            json['position'] = self.position
            return json

    # structure
    class CardCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_2.CardCondition:1.0.0"
        elements = ["enabled", "cardUid", "cardReader"]

        def __init__(self, enabled, cardUid, cardReader):
            typecheck.is_bool(enabled, AssertionError)
            typecheck.is_string(cardUid, AssertionError)
            typecheck.is_struct(cardReader, raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo, AssertionError)

            self.enabled = enabled
            self.cardUid = cardUid
            self.cardReader = cardReader

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                enabled = json['enabled'],
                cardUid = json['cardUid'],
                cardReader = raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo.decode(json['cardReader'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['cardUid'] = self.cardUid
            json['cardReader'] = raritan.rpc.smartlock.DoorAccessControl.CardReaderInfo.encode(self.cardReader)
            return json

    # structure
    class KeypadCondition(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_2.KeypadCondition:1.0.0"
        elements = ["enabled", "pin", "keypad"]

        def __init__(self, enabled, pin, keypad):
            typecheck.is_bool(enabled, AssertionError)
            typecheck.is_string(pin, AssertionError)
            typecheck.is_struct(keypad, raritan.rpc.smartlock.DoorAccessControl.KeypadInfo, AssertionError)

            self.enabled = enabled
            self.pin = pin
            self.keypad = keypad

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                enabled = json['enabled'],
                pin = json['pin'],
                keypad = raritan.rpc.smartlock.DoorAccessControl.KeypadInfo.decode(json['keypad'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['enabled'] = self.enabled
            json['pin'] = self.pin
            json['keypad'] = raritan.rpc.smartlock.DoorAccessControl.KeypadInfo.encode(self.keypad)
            return json

    # structure
    class DoorAccessRule(Structure):
        idlType = "smartlock.DoorAccessControl_1_2_2.DoorAccessRule:1.0.0"
        elements = ["name", "doorHandleLocks", "cardCondition1", "cardCondition2", "keypadCondition1", "keypadCondition2", "conditionsTimeout", "absoluteTime", "periodicTime"]

        def __init__(self, name, doorHandleLocks, cardCondition1, cardCondition2, keypadCondition1, keypadCondition2, conditionsTimeout, absoluteTime, periodicTime):
            typecheck.is_string(name, AssertionError)
            for x0 in doorHandleLocks:
                typecheck.is_interface(x0, raritan.rpc.peripheral.DeviceSlot, AssertionError)
            typecheck.is_struct(cardCondition1, raritan.rpc.smartlock.DoorAccessControl.CardCondition, AssertionError)
            typecheck.is_struct(cardCondition2, raritan.rpc.smartlock.DoorAccessControl.CardCondition, AssertionError)
            typecheck.is_struct(keypadCondition1, raritan.rpc.smartlock.DoorAccessControl.KeypadCondition, AssertionError)
            typecheck.is_struct(keypadCondition2, raritan.rpc.smartlock.DoorAccessControl.KeypadCondition, AssertionError)
            typecheck.is_int(conditionsTimeout, AssertionError)
            typecheck.is_struct(absoluteTime, raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition, AssertionError)
            typecheck.is_struct(periodicTime, raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition, AssertionError)

            self.name = name
            self.doorHandleLocks = doorHandleLocks
            self.cardCondition1 = cardCondition1
            self.cardCondition2 = cardCondition2
            self.keypadCondition1 = keypadCondition1
            self.keypadCondition2 = keypadCondition2
            self.conditionsTimeout = conditionsTimeout
            self.absoluteTime = absoluteTime
            self.periodicTime = periodicTime

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                doorHandleLocks = [Interface.decode(x0, agent) for x0 in json['doorHandleLocks']],
                cardCondition1 = raritan.rpc.smartlock.DoorAccessControl.CardCondition.decode(json['cardCondition1'], agent),
                cardCondition2 = raritan.rpc.smartlock.DoorAccessControl.CardCondition.decode(json['cardCondition2'], agent),
                keypadCondition1 = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.decode(json['keypadCondition1'], agent),
                keypadCondition2 = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.decode(json['keypadCondition2'], agent),
                conditionsTimeout = json['conditionsTimeout'],
                absoluteTime = raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition.decode(json['absoluteTime'], agent),
                periodicTime = raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition.decode(json['periodicTime'], agent),
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['doorHandleLocks'] = [Interface.encode(x0) for x0 in self.doorHandleLocks]
            json['cardCondition1'] = raritan.rpc.smartlock.DoorAccessControl.CardCondition.encode(self.cardCondition1)
            json['cardCondition2'] = raritan.rpc.smartlock.DoorAccessControl.CardCondition.encode(self.cardCondition2)
            json['keypadCondition1'] = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.encode(self.keypadCondition1)
            json['keypadCondition2'] = raritan.rpc.smartlock.DoorAccessControl.KeypadCondition.encode(self.keypadCondition2)
            json['conditionsTimeout'] = self.conditionsTimeout
            json['absoluteTime'] = raritan.rpc.smartlock.DoorAccessControl.AbsoluteTimeCondition.encode(self.absoluteTime)
            json['periodicTime'] = raritan.rpc.smartlock.DoorAccessControl.PeriodicTimeCondition.encode(self.periodicTime)
            return json

    # enumeration
    class DoorAccessDenialReason(Enumeration):
        idlType = "smartlock.DoorAccessControl_1_2_2.DoorAccessDenialReason:1.0.0"
        values = ["DENIED_NO_MATCHING_RULE", "DENIED_ABSOLUTE_TIME_CONDITION", "DENIED_PERIODIC_TIME_CONDITION", "DENIED_CONDITIONS_TIMEOUT"]

    DoorAccessDenialReason.DENIED_NO_MATCHING_RULE = DoorAccessDenialReason(0)
    DoorAccessDenialReason.DENIED_ABSOLUTE_TIME_CONDITION = DoorAccessDenialReason(1)
    DoorAccessDenialReason.DENIED_PERIODIC_TIME_CONDITION = DoorAccessDenialReason(2)
    DoorAccessDenialReason.DENIED_CONDITIONS_TIMEOUT = DoorAccessDenialReason(3)

    # value object
    class DoorAccessGrantedEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.DoorAccessControl_1_2_2.DoorAccessGrantedEvent:1.0.0"

        def __init__(self, ruleId, rule, source):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessGrantedEvent, self).__init__(source)
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.rule = rule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessGrantedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.rule)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                ruleId = json['ruleId'],
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['rule'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "rule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessGrantedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessDeniedEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.DoorAccessControl_1_2_2.DoorAccessDeniedEvent:1.0.0"

        def __init__(self, reason, ruleId, ruleName, source):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessDeniedEvent, self).__init__(source)
            typecheck.is_enum(reason, raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason, AssertionError)
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_string(ruleName, AssertionError)

            self.reason = reason
            self.ruleId = ruleId
            self.ruleName = ruleName

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessDeniedEvent, self).encode()
            json['reason'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason.encode(self.reason)
            json['ruleId'] = self.ruleId
            json['ruleName'] = self.ruleName
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                reason = raritan.rpc.smartlock.DoorAccessControl.DoorAccessDenialReason.decode(json['reason']),
                ruleId = json['ruleId'],
                ruleName = json['ruleName'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["reason", "ruleId", "ruleName"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessDeniedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessRuleAddedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.DoorAccessControl_1_2_2.DoorAccessRuleAddedEvent:1.0.0"

        def __init__(self, ruleId, rule, actUserName, actIpAddr, source):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleAddedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.rule = rule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleAddedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.rule)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                ruleId = json['ruleId'],
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['rule'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "rule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleAddedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessRuleChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.DoorAccessControl_1_2_2.DoorAccessRuleChangedEvent:1.0.0"

        def __init__(self, ruleId, oldRule, newRule, actUserName, actIpAddr, source):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(oldRule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)
            typecheck.is_struct(newRule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.oldRule = oldRule
            self.newRule = newRule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleChangedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['oldRule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.oldRule)
            json['newRule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.newRule)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                ruleId = json['ruleId'],
                oldRule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['oldRule'], agent),
                newRule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['newRule'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "oldRule", "newRule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleChangedEvent, self).listElements()
            return elements

    # value object
    class DoorAccessRuleDeletedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.DoorAccessControl_1_2_2.DoorAccessRuleDeletedEvent:1.0.0"

        def __init__(self, ruleId, rule, actUserName, actIpAddr, source):
            super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleDeletedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_int(ruleId, AssertionError)
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)

            self.ruleId = ruleId
            self.rule = rule

        def encode(self):
            json = super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleDeletedEvent, self).encode()
            json['ruleId'] = self.ruleId
            json['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(self.rule)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                ruleId = json['ruleId'],
                rule = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(json['rule'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["ruleId", "rule"]
            elements = elements + super(raritan.rpc.smartlock.DoorAccessControl.DoorAccessRuleDeletedEvent, self).listElements()
            return elements

    class _getDoorAccessRules(Interface.Method):
        name = 'getDoorAccessRules'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_

    class _setAllDoorAccessRules(Interface.Method):
        name = 'setAllDoorAccessRules'

        @staticmethod
        def encode(rules):
            args = {}
            args['rules'] = [dict(
                key = k,
                value = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(v))
                for k, v in rules.items()]
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            invalidRuleIds = [x0 for x0 in rsp['invalidRuleIds']]
            typecheck.is_int(_ret_, DecodeException)
            for x0 in invalidRuleIds:
                typecheck.is_int(x0, DecodeException)
            return (_ret_, invalidRuleIds)

    class _addDoorAccessRule(Interface.Method):
        name = 'addDoorAccessRule'

        @staticmethod
        def encode(rule):
            typecheck.is_struct(rule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)
            args = {}
            args['rule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(rule)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            ruleId = rsp['ruleId']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_int(ruleId, DecodeException)
            return (_ret_, ruleId)

    class _modifyDoorAccessRule(Interface.Method):
        name = 'modifyDoorAccessRule'

        @staticmethod
        def encode(id, modifiedRule):
            typecheck.is_int(id, AssertionError)
            typecheck.is_struct(modifiedRule, raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule, AssertionError)
            args = {}
            args['id'] = id
            args['modifiedRule'] = raritan.rpc.smartlock.DoorAccessControl.DoorAccessRule.encode(modifiedRule)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _deleteDoorAccessRule(Interface.Method):
        name = 'deleteDoorAccessRule'

        @staticmethod
        def encode(id):
            typecheck.is_int(id, AssertionError)
            args = {}
            args['id'] = id
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DoorAccessControl, self).__init__(target, agent)
        self.getDoorAccessRules = DoorAccessControl._getDoorAccessRules(self)
        self.setAllDoorAccessRules = DoorAccessControl._setAllDoorAccessRules(self)
        self.addDoorAccessRule = DoorAccessControl._addDoorAccessRule(self)
        self.modifyDoorAccessRule = DoorAccessControl._modifyDoorAccessRule(self)
        self.deleteDoorAccessRule = DoorAccessControl._deleteDoorAccessRule(self)

#
# Section generated by IdlC from "Keypad.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.smartlock


# interface
class Keypad(Interface):
    idlType = "smartlock.Keypad:1.0.0"

    NO_ERROR = 0

    ERR_SLOT_EMPTY = 1

    # structure
    class MetaData(Structure):
        idlType = "smartlock.Keypad.MetaData:1.0.0"
        elements = ["id", "manufacturer", "product", "serialNumber", "channel", "position"]

        def __init__(self, id, manufacturer, product, serialNumber, channel, position):
            typecheck.is_string(id, AssertionError)
            typecheck.is_string(manufacturer, AssertionError)
            typecheck.is_string(product, AssertionError)
            typecheck.is_string(serialNumber, AssertionError)
            typecheck.is_int(channel, AssertionError)
            typecheck.is_string(position, AssertionError)

            self.id = id
            self.manufacturer = manufacturer
            self.product = product
            self.serialNumber = serialNumber
            self.channel = channel
            self.position = position

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                id = json['id'],
                manufacturer = json['manufacturer'],
                product = json['product'],
                serialNumber = json['serialNumber'],
                channel = json['channel'],
                position = json['position'],
            )
            return obj

        def encode(self):
            json = {}
            json['id'] = self.id
            json['manufacturer'] = self.manufacturer
            json['product'] = self.product
            json['serialNumber'] = self.serialNumber
            json['channel'] = self.channel
            json['position'] = self.position
            return json

    # value object
    class PINEnteredEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.Keypad.PINEnteredEvent:1.0.0"

        def __init__(self, metaData, source):
            super(raritan.rpc.smartlock.Keypad.PINEnteredEvent, self).__init__(source)
            typecheck.is_struct(metaData, raritan.rpc.smartlock.Keypad.MetaData, AssertionError)

            self.metaData = metaData

        def encode(self):
            json = super(raritan.rpc.smartlock.Keypad.PINEnteredEvent, self).encode()
            json['metaData'] = raritan.rpc.smartlock.Keypad.MetaData.encode(self.metaData)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["metaData"]
            elements = elements + super(raritan.rpc.smartlock.Keypad.PINEnteredEvent, self).listElements()
            return elements

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.smartlock.Keypad.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.smartlock.Keypad.MetaData, DecodeException)
            return _ret_

    class _getPIN(Interface.Method):
        name = 'getPIN'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            pin = rsp['pin']
            typecheck.is_int(_ret_, DecodeException)
            typecheck.is_string(pin, DecodeException)
            return (_ret_, pin)
    def __init__(self, target, agent):
        super(Keypad, self).__init__(target, agent)
        self.getMetaData = Keypad._getMetaData(self)
        self.getPIN = Keypad._getPIN(self)

#
# Section generated by IdlC from "KeypadManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.smartlock


# interface
class KeypadManager(Interface):
    idlType = "smartlock.KeypadManager:1.0.1"

    # structure
    class KeypadSettings(Structure):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadSettings:1.0.0"
        elements = ["name", "description"]

        def __init__(self, name, description):
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(description, AssertionError)

            self.name = name
            self.description = description

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                description = json['description'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['description'] = self.description
            return json

    # value object
    class KeypadEvent(raritan.rpc.idl.Event):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadEvent:1.0.0"

        def __init__(self, keypad, metaData, source):
            super(raritan.rpc.smartlock.KeypadManager.KeypadEvent, self).__init__(source)
            typecheck.is_interface(keypad, raritan.rpc.smartlock.Keypad, AssertionError)
            typecheck.is_struct(metaData, raritan.rpc.smartlock.Keypad.MetaData, AssertionError)

            self.keypad = keypad
            self.metaData = metaData

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadEvent, self).encode()
            json['keypad'] = Interface.encode(self.keypad)
            json['metaData'] = raritan.rpc.smartlock.Keypad.MetaData.encode(self.metaData)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                keypad = Interface.decode(json['keypad'], agent),
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["keypad", "metaData"]
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadEvent, self).listElements()
            return elements

    # value object
    class KeypadAttachedEvent(KeypadEvent):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadAttachedEvent:1.0.0"

        def __init__(self, keypad, metaData, source):
            super(raritan.rpc.smartlock.KeypadManager.KeypadAttachedEvent, self).__init__(keypad, metaData, source)

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadAttachedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for smartlock.KeypadManager_1_0_1.KeypadEvent
                keypad = Interface.decode(json['keypad'], agent),
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadAttachedEvent, self).listElements()
            return elements

    # value object
    class KeypadDetachedEvent(KeypadEvent):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadDetachedEvent:1.0.0"

        def __init__(self, keypad, metaData, source):
            super(raritan.rpc.smartlock.KeypadManager.KeypadDetachedEvent, self).__init__(keypad, metaData, source)

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadDetachedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for smartlock.KeypadManager_1_0_1.KeypadEvent
                keypad = Interface.decode(json['keypad'], agent),
                metaData = raritan.rpc.smartlock.Keypad.MetaData.decode(json['metaData'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadDetachedEvent, self).listElements()
            return elements

    # value object
    class KeypadSettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "smartlock.KeypadManager_1_0_1.KeypadSettingsChangedEvent:1.0.0"

        def __init__(self, keypad, oldSettings, newSettings, position, actUserName, actIpAddr, source):
            super(raritan.rpc.smartlock.KeypadManager.KeypadSettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_interface(keypad, raritan.rpc.smartlock.Keypad, AssertionError)
            typecheck.is_struct(oldSettings, raritan.rpc.smartlock.KeypadManager.KeypadSettings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.smartlock.KeypadManager.KeypadSettings, AssertionError)
            typecheck.is_string(position, AssertionError)

            self.keypad = keypad
            self.oldSettings = oldSettings
            self.newSettings = newSettings
            self.position = position

        def encode(self):
            json = super(raritan.rpc.smartlock.KeypadManager.KeypadSettingsChangedEvent, self).encode()
            json['keypad'] = Interface.encode(self.keypad)
            json['oldSettings'] = raritan.rpc.smartlock.KeypadManager.KeypadSettings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.smartlock.KeypadManager.KeypadSettings.encode(self.newSettings)
            json['position'] = self.position
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                keypad = Interface.decode(json['keypad'], agent),
                oldSettings = raritan.rpc.smartlock.KeypadManager.KeypadSettings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.smartlock.KeypadManager.KeypadSettings.decode(json['newSettings'], agent),
                position = json['position'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["keypad", "oldSettings", "newSettings", "position"]
            elements = elements + super(raritan.rpc.smartlock.KeypadManager.KeypadSettingsChangedEvent, self).listElements()
            return elements

    class _getKeypads(Interface.Method):
        name = 'getKeypads'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.smartlock.Keypad, DecodeException)
            return _ret_

    class _getKeypadById(Interface.Method):
        name = 'getKeypadById'

        @staticmethod
        def encode(keypadId):
            typecheck.is_string(keypadId, AssertionError)
            args = {}
            args['keypadId'] = keypadId
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.smartlock.Keypad, DecodeException)
            return _ret_

    class _setKeypadSettings(Interface.Method):
        name = 'setKeypadSettings'

        @staticmethod
        def encode(position, setting):
            typecheck.is_string(position, AssertionError)
            typecheck.is_struct(setting, raritan.rpc.smartlock.KeypadManager.KeypadSettings, AssertionError)
            args = {}
            args['position'] = position
            args['setting'] = raritan.rpc.smartlock.KeypadManager.KeypadSettings.encode(setting)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getAllKeypadSettings(Interface.Method):
        name = 'getAllKeypadSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = dict([(
                elem['key'],
                raritan.rpc.smartlock.KeypadManager.KeypadSettings.decode(elem['value'], agent))
                for elem in rsp['_ret_']])
            return _ret_
    def __init__(self, target, agent):
        super(KeypadManager, self).__init__(target, agent)
        self.getKeypads = KeypadManager._getKeypads(self)
        self.getKeypadById = KeypadManager._getKeypadById(self)
        self.setKeypadSettings = KeypadManager._setKeypadSettings(self)
        self.getAllKeypadSettings = KeypadManager._getAllKeypadSettings(self)
