% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runs.R
\name{runs}
\alias{runs}
\alias{vec_identify_runs}
\alias{vec_run_sizes}
\title{Runs}
\usage{
vec_identify_runs(x)

vec_run_sizes(x)
}
\arguments{
\item{x}{A vector.}
}
\value{
\itemize{
\item For \code{vec_identify_runs()}, an integer vector with the same size as \code{x}. A
scalar integer attribute, \code{n}, is attached.
\item For \code{vec_run_sizes()}, an integer vector with size equal to the number of
runs in \code{x}.
}
}
\description{
\itemize{
\item \code{vec_identify_runs()} returns a vector of identifiers for the elements of
\code{x} that indicate which run of repeated values they fall in. The number of
runs is also returned as an attribute, \code{n}.
\item \code{vec_run_sizes()} returns an integer vector corresponding to the size of
each run. This is identical to the \code{times} column from \code{vec_unrep()}, but
is faster if you don't need the run keys.
\item \code{\link[=vec_unrep]{vec_unrep()}} is a generalized \code{\link[base:rle]{base::rle()}}. It is documented alongside
the "repeat" functions of \code{\link[=vec_rep]{vec_rep()}} and \code{\link[=vec_rep_each]{vec_rep_each()}}; look there for
more information.
}
}
\details{
Unlike \code{\link[base:rle]{base::rle()}}, adjacent missing values are considered identical when
constructing runs. For example, \code{vec_identify_runs(c(NA, NA))} will return
\code{c(1, 1)}, not \code{c(1, 2)}.
}
\examples{
x <- c("a", "z", "z", "c", "a", "a")

vec_identify_runs(x)
vec_run_sizes(x)
vec_unrep(x)

y <- c(1, 1, 1, 2, 2, 3)

# With multiple columns, the runs are constructed rowwise
df <- data_frame(
  x = x,
  y = y
)

vec_identify_runs(df)
vec_run_sizes(df)
vec_unrep(df)
}
\seealso{
\code{\link[=vec_unrep]{vec_unrep()}} for a generalized \code{\link[base:rle]{base::rle()}}.
}
