% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_github_file.R
\name{use_github_file}
\alias{use_github_file}
\title{Copy a file from any GitHub repo into the current project}
\usage{
use_github_file(
  repo_spec,
  path = NULL,
  save_as = NULL,
  ref = NULL,
  ignore = FALSE,
  open = FALSE,
  host = NULL
)
}
\arguments{
\item{repo_spec}{A string identifying the GitHub repo or, alternatively, a
GitHub file URL. Acceptable forms:
\itemize{
\item Plain \code{OWNER/REPO} spec
\item A blob URL, such as \code{"https://github.com/OWNER/REPO/blob/REF/path/to/some/file"}
\item A raw URL, such as \code{"https://raw.githubusercontent.com/OWNER/REPO/REF/path/to/some/file"}
}

In the case of a URL, the \code{path}, \code{ref}, and \code{host} are extracted from it, in
addition to the \code{repo_spec}.}

\item{path}{Path of file to copy, relative to the GitHub repo it lives in.
This is extracted from \code{repo_spec} when user provides a URL.}

\item{save_as}{Path of file to create, relative to root of active project.
Defaults to the last part of \code{path}, in the sense of \code{basename(path)} or
\code{fs::path_file(path)}.}

\item{ref}{The name of a branch, tag, or commit. By default, the file at
\code{path} will be copied from its current state in the repo's default branch.
This is extracted from \code{repo_spec} when user provides a URL.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}

\item{host}{GitHub host to target, passed to the \code{.api_url} argument of
\code{\link[gh:gh]{gh::gh()}}. If unspecified, gh defaults to "https://api.github.com",
although gh's default can be customised by setting the GITHUB_API_URL
environment variable.

For a hypothetical GitHub Enterprise instance, either
"https://github.acme.com/api/v3" or "https://github.acme.com" is
acceptable.}
}
\value{
A logical indicator of whether a file was written, invisibly.
}
\description{
Gets the content of a file from GitHub, from any repo the user can read, and
writes it into the active project. This function wraps an endpoint of the
GitHub API which supports specifying a target reference (i.e. branch, tag,
or commit) and which follows symlinks.
}
\examples{
\dontrun{
use_github_file(
  "https://github.com/r-lib/actions/blob/v2/examples/check-standard.yaml"
)

use_github_file(
  "r-lib/actions",
  path = "examples/check-standard.yaml",
  ref = "v2",
  save_as = ".github/workflows/R-CMD-check.yaml"
)
}
}
