% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tween_sf.R
\name{tween_sf}
\alias{tween_sf}
\title{Transition between data.frames containing sfc columns}
\usage{
tween_sf(.data, to, ease, nframes, id = NULL, enter = NULL, exit = NULL)
}
\arguments{
\item{.data}{A data.frame to start from. If \code{.data} is the result of a prior
tween, only the last frame will be used for the tween. The new tween will
then be added to the prior tween}

\item{to}{A data.frame to end at. It must contain the same columns as .data
(exluding \code{.frame})}

\item{ease}{The easing function to use. Either a single string or one for
each column in the data set.}

\item{nframes}{The number of frames to calculate for the tween}

\item{id}{The column to match observations on. If \code{NULL} observations will be
matched by position. See the \emph{Match, Enter, and Exit} section for more
information.}

\item{enter}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}

\item{exit}{functions that calculate a start state for new observations
that appear in \code{to} or an end state for observations that are not present in
\code{to}. If \code{NULL} the new/old observations will not be part of the tween. The
function gets a data.frame with either the start state of the exiting
observations, or the end state of the entering observations and must return
a modified version of that data.frame. See the \emph{Match, Enter, and Exit}
section for more information.}
}
\value{
A data.frame containing intermediary states
}
\description{
This function is equivalent to \code{\link[tweenr:tween_state]{tweenr::tween_state()}} except that it
understands \code{\link[sf:sfc]{sf::sfc}} columns, as defined by the \code{sf} package. An \code{sfc}
column is a column containing simple features and can this hold both points,
lines polygons and more. \code{tween_sf} currently has support for (multi)point,
(multi)linestring, and (multi)polygon types and requires that the transition
is between compatible types (points-to-points, linestring-to-linestring,
polygon-to-polygon). For (multi)linestring and (multi)polygon, the behavior
is similar to \code{\link[=tween_path]{tween_path()}} and \code{\link[=tween_polygon]{tween_polygon()}} respectively, with each
feature beeing run through the respective function with \code{match = FALSE}. For
(multi)points it behaves more or less like \code{\link[tweenr:tween_state]{tweenr::tween_state()}} except
additional points are added as needed to make the to stages contain the same
number of points. Points are added on top of existing points so it appears as
if the points are divided into more.
}
\examples{
library(magrittr)
star_hole <- poly_star_hole(st = TRUE)
circles <- poly_circles(st = TRUE)
spiral <- path_spiral(st = TRUE)
waves <- path_waves(st = TRUE)
random <- point_random(st = TRUE)
grid <- point_grid(st = TRUE)
df1 <- data.frame(geo = sf::st_sfc(star_hole, spiral, random))
df2 <- data.frame(geo = sf::st_sfc(circles, waves, grid))

tween_sf(df1, df2, 'linear', 30)

}
