% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expectations-equality.R
\name{expect_equal_to_reference}
\alias{expect_equal_to_reference}
\title{Expectation: is the object equal to a reference value stored in a file?}
\usage{
expect_equal_to_reference(object, file, ..., info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
\item{object}{object to test}

\item{file}{The file name used to store the object. Should have an "rds"
extension.}

\item{...}{other values passed to \code{\link{expect_equal}}}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{For the full form, a label for the expected object, which is
used in error messages. Useful to override the default (which is based on
the file name), when doing tests in a loop. For the short-cut form, the
object label, which is computed from the deparsed object by default.}

\item{expected.label}{Equivalent of \code{label} for shortcut form.}
}
\description{
This expectation is equivalent to \code{\link{expect_equal}}, except that the
expected value is stored in an RDS file instead of being specified literally.
This can be helpful when the value is necessarily complex. If the file does
not exist then it will be created using the value of the specified object,
and subsequent tests will check for consistency against that generated value.
The test can be reset by deleting the RDS file.
}
\details{
It is important to initialize the reference RDS file within the source
package, most likely in the \code{tests/testthat/} directory. Testing spawned
by \code{devtools::test()}, for example, will accomplish this. But note that
testing spawned by \code{R CMD check} and \code{devtools::check()} will NOT.
In the latter cases, the package source is copied to an external location
before tests are run. The resulting RDS file will not make its way back into
the package source and will not be available for subsequent comparisons.
}
\examples{
\dontrun{
expect_equal_to_reference(1, "one.rds")
}
}
\seealso{
Other expectations: \code{\link{equivalence}},
  \code{\link{expect_equal}},
  \code{\link{expect_equivalent}},
  \code{\link{expect_identical}};
  \code{\link{expect-compare}}, \code{\link{expect_gt}},
  \code{\link{expect_gte}}, \code{\link{expect_less_than}},
  \code{\link{expect_lt}}, \code{\link{expect_lte}},
  \code{\link{expect_more_than}};
  \code{\link{expect_error}}, \code{\link{expect_match}},
  \code{\link{expect_message}},
  \code{\link{expect_output}},
  \code{\link{expect_warning}},
  \code{\link{matching-expectations}};
  \code{\link{expect_false}}, \code{\link{expect_true}};
  \code{\link{expect_is}}; \code{\link{expect_named}};
  \code{\link{expect_null}}; \code{\link{expect_silent}};
  \code{\link{takes_less_than}}
}

