% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_zone.R
\name{stri_timezone_list}
\alias{stri_timezone_list}
\title{List Available Time Zone Identifiers}
\usage{
stri_timezone_list(region = NA_character_, offset = NA_integer_)
}
\arguments{
\item{region}{single string;
a ISO 3166 two-letter country code or UN M.49 three-digit area code;
\code{NA} for all regions}

\item{offset}{single numeric value;
a given raw offset from GMT, in hours;
\code{NA} for all offsets}
}
\value{
Returns a character vector.
}
\description{
Returns a list of available time zone identifiers.
}
\details{
If \code{offset} and \code{region} are \code{NA} (the default), then
all time zones are returned. Otherwise,
only time zone identifiers with a given raw offset from GMT
and/or time zones corresponding to a given region are provided.
Note that the effect of daylight savings time is ignored.

A time zone represents an offset applied to the Greenwich Mean Time (GMT)
to obtain local time (Universal Coordinated Time, or UTC, is similar,
but not precisely identical, to GMT; in \pkg{ICU} the two terms
are used interchangeably since \pkg{ICU} does not concern itself with
either leap seconds or historical behavior).
The offset might vary throughout the year, if daylight savings time (DST)
is used, or might be the same all year long.
Typically, regions closer to the equator do not use DST.
If DST is in use, then specific rules define the point where
the offset changes and the amount by which it changes.

If DST is observed, then three additional bits of information are needed:
\enumerate{
\item The precise date and time during the year when DST begins.
In the first half of the year it is in the northern hemisphere,
and in the second half of the year it is in the southern hemisphere.
\item The precise date and time during the year when DST ends.
In the first half of the year it is in the southern hemisphere,
and in the second half of the year it is in the northern hemisphere.
\item The amount by which the GMT offset changes when DST is in effect.
This is almost always one hour.
}
}
\examples{
stri_timezone_list()
stri_timezone_list(offset=1)
stri_timezone_list(offset=5.5)
stri_timezone_list(offset=5.75)
stri_timezone_list(region='PL')
stri_timezone_list(region='US', offset=-10)

# Fetch information on all time zones
do.call(rbind.data.frame,
   lapply(stri_timezone_list(), function(tz) stri_timezone_info(tz)))

}
\references{
\emph{TimeZone} class -- ICU API Documentation,
\url{https://unicode-org.github.io/icu-docs/apidoc/dev/icu4c/classicu_1_1TimeZone.html}

\emph{ICU TimeZone classes} -- ICU User Guide,
\url{https://unicode-org.github.io/icu/userguide/datetime/timezone/}

\emph{Date/Time Services} -- ICU User Guide,
\url{https://unicode-org.github.io/icu/userguide/datetime/}
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other datetime: 
\code{\link{stri_datetime_add}()},
\code{\link{stri_datetime_create}()},
\code{\link{stri_datetime_fields}()},
\code{\link{stri_datetime_format}()},
\code{\link{stri_datetime_fstr}()},
\code{\link{stri_datetime_now}()},
\code{\link{stri_datetime_symbols}()},
\code{\link{stri_timezone_get}()},
\code{\link{stri_timezone_info}()}

Other timezone: 
\code{\link{stri_timezone_get}()},
\code{\link{stri_timezone_info}()}
}
\concept{datetime}
\concept{timezone}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
