% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_count_bound.R
\name{stri_count_boundaries}
\alias{stri_count_boundaries}
\alias{stri_count_words}
\title{Count the Number of Text Boundaries}
\usage{
stri_count_boundaries(str, ..., opts_brkiter = NULL)

stri_count_words(str, locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{...}{additional settings for \code{opts_brkiter}}

\item{opts_brkiter}{a named list with \pkg{ICU} BreakIterator's settings,
see \code{\link{stri_opts_brkiter}};
\code{NULL} for the default break iterator, i.e., \code{line_break}}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale}}
}
\value{
Both functions return an integer vector.
}
\description{
These functions determine the number of text boundaries
(like character, word, line, or sentence boundaries) in a string.
}
\details{
Vectorized over \code{str}.

For more information on text boundary analysis
performed by \pkg{ICU}'s \code{BreakIterator}, see
\link{stringi-search-boundaries}.

In case of \code{stri_count_words},
just like in \code{\link{stri_extract_all_words}} and
\code{\link{stri_locate_all_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate the word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
This function is equivalent to a call to
\code{\link{stri_count_boundaries}(str, type="word", skip_word_none=TRUE, locale=locale)}.

Note that a \code{BreakIterator} of type \code{character}
may be used to count the number of \emph{Unicode characters} in a string.
The \code{\link{stri_length}} function,
which aims to count the number of \emph{Unicode code points},
might report different results.

Moreover, a \code{BreakIterator} of type \code{sentence}
may be used to count the number of sentences in a text piece.
}
\examples{
test <- "The\u00a0above-mentioned    features are very useful. Kudos to their developers."
stri_count_boundaries(test, type="word")
stri_count_boundaries(test, type="sentence")
stri_count_boundaries(test, type="character")
stri_count_words(test)

test2 <- stri_trans_nfkd("\u03c0\u0153\u0119\u00a9\u00df\u2190\u2193\u2192")
stri_count_boundaries(test2, type="character")
stri_length(test2)
stri_numbytes(test2)

}
\seealso{
Other search_count: 
\code{\link{stri_count}()},
\code{\link{stringi-search}}

Other locale_sensitive: 
\code{\link{\%s<\%}()},
\code{\link{stri_compare}()},
\code{\link{stri_duplicated}()},
\code{\link{stri_enc_detect2}()},
\code{\link{stri_extract_all_boundaries}()},
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_opts_collator}()},
\code{\link{stri_order}()},
\code{\link{stri_sort}()},
\code{\link{stri_split_boundaries}()},
\code{\link{stri_trans_tolower}()},
\code{\link{stri_unique}()},
\code{\link{stri_wrap}()},
\code{\link{stringi-locale}},
\code{\link{stringi-search-boundaries}},
\code{\link{stringi-search-coll}}

Other text_boundaries: 
\code{\link{stri_extract_all_boundaries}()},
\code{\link{stri_locate_all_boundaries}()},
\code{\link{stri_opts_brkiter}()},
\code{\link{stri_split_boundaries}()},
\code{\link{stri_split_lines}()},
\code{\link{stri_trans_tolower}()},
\code{\link{stri_wrap}()},
\code{\link{stringi-search-boundaries}},
\code{\link{stringi-search}}
}
\concept{locale_sensitive}
\concept{search_count}
\concept{text_boundaries}
