% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_models.R
\name{plot_models}
\alias{plot_models}
\title{Forest plot of multiple regression models}
\usage{
plot_models(
  ...,
  transform = NULL,
  std.est = NULL,
  rm.terms = NULL,
  title = NULL,
  m.labels = NULL,
  legend.title = "Dependent Variables",
  legend.pval.title = "p-level",
  axis.labels = NULL,
  axis.title = NULL,
  axis.lim = NULL,
  wrap.title = 50,
  wrap.labels = 25,
  wrap.legend.title = 20,
  grid.breaks = NULL,
  dot.size = 3,
  line.size = NULL,
  value.size = NULL,
  spacing = 0.4,
  colors = "Set1",
  show.values = FALSE,
  show.legend = TRUE,
  show.intercept = FALSE,
  show.p = TRUE,
  p.shape = FALSE,
  p.threshold = c(0.05, 0.01, 0.001),
  p.adjust = NULL,
  ci.lvl = 0.95,
  robust = FALSE,
  vcov.fun = NULL,
  vcov.type = c("HC3", "const", "HC", "HC0", "HC1", "HC2", "HC4", "HC4m", "HC5"),
  vcov.args = NULL,
  vline.color = NULL,
  digits = 2,
  grid = FALSE,
  auto.label = TRUE,
  prefix.labels = c("none", "varname", "label")
)
}
\arguments{
\item{...}{One or more regression models, including glm's or mixed models.
May also be a \code{list} with fitted models. See 'Examples'.}

\item{transform}{A character vector, naming a function that will be applied
on estimates and confidence intervals. By default, \code{transform} will
automatically use \code{"exp"} as transformation for applicable classes of
\code{model} (e.g. logistic or poisson regression). Estimates of linear
models remain untransformed. Use \code{NULL} if you want the raw,
non-transformed estimates.}

\item{std.est}{Choose whether standardized coefficients should be used
for plotting. Default is no standardization (\code{std.est = NULL}).
May be \code{"std"} for standardized beta values or \code{"std2"}, where
standardization is done by rescaling estimates by dividing them by two sd.}

\item{rm.terms}{Character vector with names that indicate which terms should
be removed from the plot. Counterpart to \code{terms}. \code{rm.terms =
"t_name"} would remove the term \emph{t_name}. Default is \code{NULL}, i.e.
all terms are used. For factors, levels that should be removed from the plot
need to be explicitely indicated in square brackets, and match the model's
coefficient names, e.g. \code{rm.terms = "t_name [2,3]"} would remove the terms
\code{"t_name2"} and \code{"t_name3"} (assuming that the variable \code{t_name}
was categorical and has at least the factor levels \code{2} and \code{3}).
Another example for the \emph{iris} dataset would be
\code{rm.terms = "Species [versicolor,virginica]"}. Note that the
\code{rm.terms}-argument does not apply to \emph{Marginal Effects} plots.}

\item{title}{Character vector, used as plot title. By default,
\code{\link[sjlabelled]{response_labels}} is called to retrieve the label of
the dependent variable, which will be used as title. Use \code{title = ""}
to remove title.}

\item{m.labels}{Character vector, used to indicate the different models
in the plot's legend. If not specified, the labels of the dependent
variables for each model are used.}

\item{legend.title}{Character vector, used as legend title for plots that
have a legend.}

\item{legend.pval.title}{Character vector, used as title of the plot legend that
indicates the p-values. Default is \code{"p-level"}. Only applies if
\code{p.shape = TRUE}.}

\item{axis.labels}{Character vector with labels for the model terms, used as
axis labels. By default, \code{\link[sjlabelled]{term_labels}} is
called to retrieve the labels of the coefficients, which will be used as
axis labels. Use \code{axis.labels = ""} or \code{auto.label = FALSE} to
use the variable names as labels instead. If \code{axis.labels} is a named
vector, axis labels (by default, the names of the model's coefficients)
will be matched with the names of \code{axis.label}. This ensures that
labels always match the related axis value, no matter in which way
axis labels are sorted.}

\item{axis.title}{Character vector of length one or two (depending on the
plot function and type), used as title(s) for the x and y axis. If not
specified, a default labelling  is chosen. \strong{Note:} Some plot types
may not support this argument sufficiently. In such cases, use the returned
ggplot-object and add axis titles manually with
\code{\link[ggplot2]{labs}}. Use \code{axis.title = ""} to remove axis
titles.}

\item{axis.lim}{Numeric vector of length 2, defining the range of the plot
axis. Depending on plot-type, may effect either x- or y-axis. For
\emph{Marginal Effects} plots, \code{axis.lim} may also be a list of two
vectors of length 2, defining axis limits for both the x and y axis.}

\item{wrap.title}{Numeric, determines how many chars of the plot title are
displayed in one line and when a line break is inserted.}

\item{wrap.labels}{Numeric, determines how many chars of the value, variable
or axis labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{grid.breaks}{Numeric value or vector; if \code{grid.breaks} is a
single value, sets the distance between breaks for the axis at every
\code{grid.breaks}'th position, where a major grid line is plotted. If
\code{grid.breaks} is a vector, values will be used to define the
axis positions of the major grid lines.}

\item{dot.size}{Numeric, size of the dots that indicate the point estimates.}

\item{line.size}{Numeric, size of the lines that indicate the error bars.}

\item{value.size}{Numeric, indicates the size of value labels. Can be used
for all plot types where the argument \code{show.values} is applicable,
e.g. \code{value.size = 4}.}

\item{spacing}{Numeric, spacing between the dots and error bars of the
plotted fitted models. Default is 0.3.}

\item{colors}{May be a character vector of color values in hex-format, valid
color value names (see \code{demo("colors")}) or a name of a pre-defined
color palette. Following options are valid for the \code{colors} argument:
\itemize{
  \item If not specified, a default color brewer palette will be used, which is suitable for the plot style.
  \item If \code{"gs"}, a greyscale will be used.
  \item If \code{"bw"}, and plot-type is a line-plot, the plot is black/white and uses different line types to distinguish groups (see \href{https://strengejacke.github.io/sjPlot/articles/blackwhitefigures.html}{this package-vignette}).
  \item If \code{colors} is any valid color brewer palette name, the related palette will be used. Use \code{RColorBrewer::display.brewer.all()} to view all available palette names.
  \item There are some pre-defined color palettes in this package, see \code{\link{sjPlot-themes}} for details.
  \item Else specify own color values or names as vector (e.g. \code{colors = "#00ff00"} or \code{colors = c("firebrick", "blue")}).
}}

\item{show.values}{Logical, whether values should be plotted or not.}

\item{show.legend}{For \emph{Marginal Effects} plots, shows or hides the
legend.}

\item{show.intercept}{Logical, if \code{TRUE}, the intercept of the fitted
model is also plotted. Default is \code{FALSE}. If \code{transform =
"exp"}, please note that due to exponential transformation of estimates,
the intercept in some cases is non-finite and the plot can not be created.}

\item{show.p}{Logical, adds asterisks that indicate the significance level of
estimates to the value labels.}

\item{p.shape}{Logical, if \code{TRUE}, significant levels are distinguished by
different point shapes and a related legend is plotted. Default
is \code{FALSE}.}

\item{p.threshold}{Numeric vector of length 3, indicating the treshold for
annotating p-values with asterisks. Only applies if
\code{p.style = "asterisk"}.}

\item{p.adjust}{Character vector, if not \code{NULL}, indicates the method
to adjust p-values. See \code{\link[stats]{p.adjust}} for details.}

\item{ci.lvl}{Numeric, the level of the confidence intervals (error bars).
Use \code{ci.lvl = NA} to remove error bars. For \code{stanreg}-models,
\code{ci.lvl} defines the (outer) probability for the \emph{credible interval}
that is plotted (see \code{\link[bayestestR]{ci}}). By
default, \code{stanreg}-models are printed with two intervals: the "inner"
interval, which defaults to the 50\%-CI; and the "outer" interval, which
defaults to the 89\%-CI. \code{ci.lvl} affects only the outer interval in
such cases. See \code{prob.inner} and \code{prob.outer} under the
\code{...}-argument for more details.}

\item{robust}{Logical, shortcut for arguments \code{vcov.fun} and \code{vcov.type}.
If \code{TRUE}, uses \code{vcov.fun = "vcovHC"} and \code{vcov.type = "HC3"} as
default, that is, \code{\link[sandwich]{vcovHC}} with default-type is called
(see \code{\link[parameters]{standard_error_robust}} and
\href{https://easystats.github.io/parameters/articles/model_parameters_robust.html}{this vignette}
for further details).}

\item{vcov.fun}{Character vector, indicating the name of the \code{vcov*()}-function
from the \pkg{sandwich} or \pkg{clubSandwich} package, e.g. \code{vcov.fun = "vcovCL"},
if robust standard errors are required.}

\item{vcov.type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich:vcovHC]{vcovHC()}}
or \code{clubSandwich::vcovCR()} for details).}

\item{vcov.args}{List of named vectors, used as additional arguments that
are passed down to \code{vcov.fun}.}

\item{vline.color}{Color of the vertical "zero effect" line. Default color is
inherited from the current theme.}

\item{digits}{Numeric, amount of digits after decimal point when rounding
estimates or values.}

\item{grid}{Logical, if \code{TRUE}, multiple plots are plotted as grid
layout.}

\item{auto.label}{Logical, if \code{TRUE} (the default),
 and \href{https://strengejacke.github.io/sjlabelled/articles/intro_sjlabelled.html}{data is labelled},
 \code{\link[sjlabelled]{term_labels}} is called to retrieve the labels
 of the coefficients, which will be used as predictor labels. If data is
 not labelled, \href{https://easystats.github.io/parameters/reference/format_parameters.html}{format_parameters()}
 is used to create pretty labels. If \code{auto.label = FALSE},
original variable names and value labels (factor levels) are used.}

\item{prefix.labels}{Indicates whether the value labels of categorical variables
should be prefixed, e.g. with the variable name or variable label. See
argument \code{prefix} in \code{\link[sjlabelled]{term_labels}} for
details.}
}
\value{
A ggplot-object.
}
\description{
Plot and compare regression coefficients with confidence
  intervals of multiple regression models in one plot.
}
\examples{
data(efc)

# fit three models
fit1 <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
fit2 <- lm(neg_c_7 ~ c160age + c12hour + c161sex + c172code, data = efc)
fit3 <- lm(tot_sc_e ~ c160age + c12hour + c161sex + c172code, data = efc)

# plot multiple models
plot_models(fit1, fit2, fit3, grid = TRUE)

# plot multiple models with legend labels and
# point shapes instead of value labels
plot_models(
  fit1, fit2, fit3,
  axis.labels = c(
    "Carer's Age", "Hours of Care", "Carer's Sex", "Educational Status"
  ),
  m.labels = c("Barthel Index", "Negative Impact", "Services used"),
  show.values = FALSE, show.p = FALSE, p.shape = TRUE
)

\dontrun{
# plot multiple models from nested lists argument
all.models <- list()
all.models[[1]] <- fit1
all.models[[2]] <- fit2
all.models[[3]] <- fit3

plot_models(all.models)

# plot multiple models with different predictors (stepwise inclusion),
# standardized estimates
fit1 <- lm(mpg ~ wt + cyl + disp + gear, data = mtcars)
fit2 <- update(fit1, . ~ . + hp)
fit3 <- update(fit2, . ~ . + am)

plot_models(fit1, fit2, fit3, std.est = "std2")
}
}
