% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{new_transform}
\alias{new_transform}
\alias{trans}
\alias{trans_new}
\alias{is.transform}
\alias{is.trans}
\alias{as.transform}
\alias{as.trans}
\title{Create a new transformation object}
\usage{
new_transform(
  name,
  transform,
  inverse,
  d_transform = NULL,
  d_inverse = NULL,
  breaks = extended_breaks(),
  minor_breaks = regular_minor_breaks(),
  format = format_format(),
  domain = c(-Inf, Inf)
)

trans_new(
  name,
  transform,
  inverse,
  d_transform = NULL,
  d_inverse = NULL,
  breaks = extended_breaks(),
  minor_breaks = regular_minor_breaks(),
  format = format_format(),
  domain = c(-Inf, Inf)
)

is.transform(x)

is.trans(x)

as.transform(x, arg = deparse(substitute(x)))

as.trans(x, arg = deparse(substitute(x)))
}
\arguments{
\item{name}{transformation name}

\item{transform}{function, or name of function, that performs the
transformation}

\item{inverse}{function, or name of function, that performs the
inverse of the transformation}

\item{d_transform}{Optional function, or name of function, that gives the
derivative of the transformation. May be \code{NULL}.}

\item{d_inverse}{Optional function, or name of function, that gives the
derivative of the inverse of the transformation. May be \code{NULL}.}

\item{breaks}{default breaks function for this transformation. The breaks
function is applied to the un-transformed data.}

\item{minor_breaks}{default minor breaks function for this transformation.}

\item{format}{default format for this transformation. The format is applied
to breaks generated on the un-transformed data.}

\item{domain}{the allowed range of the data to be transformed. The function
in the \code{transform} argument is expected to be able to transform the \code{domain}
argument.}
}
\description{
A transformation encapsulates a transformation and its inverse, as well
as the information needed to create pleasing breaks and labels. The \code{breaks()}
function is applied on the un-transformed range of the data, and the
\code{format()} function takes the output of the \code{breaks()} function and returns
well-formatted labels. Transformations may also include the derivatives of the
transformation and its inverse, but are not required to.
}
\seealso{
\Sexpr[results=rd,stage=build]{scales:::seealso_transform()}
}
\keyword{internal}
