% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLiteResult.R, R/dbBind_SQLiteResult.R,
%   R/dbClearResult_SQLiteResult.R, R/dbColumnInfo_SQLiteResult.R,
%   R/dbFetch_SQLiteResult.R, R/dbGetRowCount_SQLiteResult.R,
%   R/dbGetRowsAffected_SQLiteResult.R, R/dbGetStatement_SQLiteResult.R,
%   R/dbHasCompleted_SQLiteResult.R, R/dbIsValid_SQLiteResult.R
\docType{class}
\name{SQLiteResult-class}
\alias{SQLiteResult-class}
\alias{dbBind_SQLiteResult}
\alias{dbBind,SQLiteResult-method}
\alias{dbClearResult_SQLiteResult}
\alias{dbClearResult,SQLiteResult-method}
\alias{dbColumnInfo_SQLiteResult}
\alias{dbColumnInfo,SQLiteResult-method}
\alias{dbFetch_SQLiteResult}
\alias{dbFetch,SQLiteResult-method}
\alias{dbGetRowCount_SQLiteResult}
\alias{dbGetRowCount,SQLiteResult-method}
\alias{dbGetRowsAffected_SQLiteResult}
\alias{dbGetRowsAffected,SQLiteResult-method}
\alias{dbGetStatement_SQLiteResult}
\alias{dbGetStatement,SQLiteResult-method}
\alias{dbHasCompleted_SQLiteResult}
\alias{dbHasCompleted,SQLiteResult-method}
\alias{dbIsValid_SQLiteResult}
\alias{dbIsValid,SQLiteResult-method}
\title{Class SQLiteResult (and methods)}
\usage{
\S4method{dbBind}{SQLiteResult}(res, params, ...)

\S4method{dbClearResult}{SQLiteResult}(res, ...)

\S4method{dbColumnInfo}{SQLiteResult}(res, ...)

\S4method{dbFetch}{SQLiteResult}(
  res,
  n = -1,
  ...,
  row.names = pkgconfig::get_config("RSQLite::row.names.query", FALSE)
)

\S4method{dbGetRowCount}{SQLiteResult}(res, ...)

\S4method{dbGetRowsAffected}{SQLiteResult}(res, ...)

\S4method{dbGetStatement}{SQLiteResult}(res, ...)

\S4method{dbHasCompleted}{SQLiteResult}(res, ...)

\S4method{dbIsValid}{SQLiteResult}(dbObj, ...)
}
\description{
SQLiteDriver objects are created by \code{\link[=dbSendQuery]{dbSendQuery()}} or \code{\link[=dbSendStatement]{dbSendStatement()}},
and encapsulate the result of an SQL statement (either \code{SELECT} or not).
They are a superclass of the \linkS4class{DBIResult} class.
The "Usage" section lists the class methods overridden by \pkg{RSQLite}.
}
\seealso{
The corresponding generic functions
\code{\link[DBI:dbFetch]{DBI::dbFetch()}}, \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}}, and \code{\link[DBI:dbBind]{DBI::dbBind()}},
\code{\link[DBI:dbColumnInfo]{DBI::dbColumnInfo()}}, \code{\link[DBI:dbGetRowsAffected]{DBI::dbGetRowsAffected()}}, \code{\link[DBI:dbGetRowCount]{DBI::dbGetRowCount()}},
\code{\link[DBI:dbHasCompleted]{DBI::dbHasCompleted()}}, and \code{\link[DBI:dbGetStatement]{DBI::dbGetStatement()}}.
}
\keyword{internal}
