% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_results.R
\name{plot.AnalysisResults}
\alias{plot.AnalysisResults}
\title{Analysis Results Plotting}
\usage{
\method{plot}{AnalysisResults}(
  x,
  y,
  ...,
  type = 1L,
  nPlanned = NA_real_,
  stage = x$getNumberOfStages(),
  allocationRatioPlanned = NA_real_,
  main = NA_character_,
  xlab = NA_character_,
  ylab = NA_character_,
  legendTitle = "",
  palette = "Set1",
  legendPosition = NA_integer_,
  showSource = FALSE
)
}
\arguments{
\item{x}{The analysis results at given stage, obtained from \code{\link{getAnalysisResults}}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{...}{Optional \code{ggplot2} arguments. Furthermore the following arguments can be defined:
\itemize{
\item \code{thetaRange}: A range of assumed effect sizes if testing means or a survival design was specified. 
            Additionally, if testing means was selected, an assumed standard deviation can be specified (default is 1).
\item \code{piRange}: A range of assumed rates pi1 to calculate the conditional power. 
          Additionally, if a two-sample comparison was selected, pi2 can be specified (default is the value from 
       \code{getAnalysisResults}). 
\item \code{directionUpper}: The direction of one-sided testing. 
       Default is \code{directionUpper = TRUE} which means that larger values of the 
       test statistics yield smaller p-values.
\item \code{thetaH0}: The null hypothesis value, default is 0 for the normal and the binary case, 
       it is 1 for the survival case.      
       For testing a rate in one sample, a value thetaH0 in (0,1) has to be specified for 
       defining the null hypothesis H0: pi = thetaH0.
}}

\item{type}{The plot type (default = 1). Note that at the moment only one type (the conditional power plot) is available.}

\item{nPlanned}{The additional (i.e. "new" and not cumulative) sample size planned for each of the subsequent stages. 
The argument should be a vector with length equal to the number of remaining stages and contain 
the combined sample size from both treatment groups if two groups are considered. For survival outcomes, 
it should contain the planned number of additional events.}

\item{stage}{The stage number (optional). Default: total number of existing stages in the data input
used to create the analysis results.}

\item{allocationRatioPlanned}{The allocation ratio n1/n2 for two treatment groups planned for 
the subsequent stages, the default value is 1.}

\item{main}{The main title, default is \code{"Dataset"}.}

\item{xlab}{The x-axis label, default is \code{"Stage"}.}

\item{ylab}{The y-axis label.}

\item{legendTitle}{The legend title, default is \code{""}.}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{legendPosition}{The position of the legend. 
By default (\code{NA_integer_}) the algorithm tries to find a suitable position. 
Choose one of the following values to specify the position manually:
\itemize{
  \item \code{0}: legend position outside plot
  \item \code{1}: legend position left top
  \item \code{2}: legend position left center
  \item \code{3}: legend position left bottom
  \item \code{4}: legend position right top
  \item \code{5}: legend position right center
  \item \code{6}: legend position right bottom
}}

\item{showSource}{If \code{TRUE}, the parameter names of the object will 
be printed which were used to create the plot; that may be, e.g., 
useful to check the values or to create own plots with \code{\link[graphics]{plot}}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Plots the conditional power together with the likelihood function.
}
\details{
The conditional power is calculated only if effect size and sample size is specified.
}
\examples{

design <- getDesignGroupSequential(kMax = 2)

dataExample <- getDataset(
    n = c(20, 30),
	   means = c(50, 51),
	   stDevs = c(130, 140)
)

result <- getAnalysisResults(design = design, 
	   dataInput = dataExample, thetaH0 = 20, 
	   nPlanned = c(30), thetaH1 = 1.5, stage = 1) 

if (require(ggplot2)) plot(result, thetaRange = c(0, 100))

}
