% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactions.R
\name{step_interact}
\alias{step_interact}
\title{Create Interaction Variables}
\usage{
step_interact(recipe, terms, role = "predictor", trained = FALSE,
  objects = NULL, sep = "_x_")
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{terms}{A traditional R formula that contains interaction terms.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned?. By default, the function assumes that the new columns
created from the original variables will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{objects}{A list of \code{terms} objects for each individual interation.}

\item{sep}{A character value used to delinate variables in an interaction
(e.g. \code{var1_x_var2} instead of the more traditional \code{var1:var2}).}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_interact} creates a \emph{specification} of a recipe step that
  will create new columns that are interaction terms between two or more
  variables.
}
\details{
\code{step_interact} can create interactions between variables. It
  is primarily intended for \bold{numeric data}; categorical variables
  should probably be converted to dummy variables using
  \code{\link{step_dummy}} prior to being used for interactions.

Unlike other step functions, the \code{terms} argument should be a
  traditional R model formula but should contain no inline functions (e.g.
  \code{log}). For example, for predictors \code{A}, \code{B}, and \code{C},
  a formula such as \code{~A:B:C} can be used to make a three way
  interaction between the variables. If the formula contains terms other
  than interactions (e.g. \code{(A+B+C)^3}) only the interaction terms are
  retained for the design matrix.

The separator between the variables defaults to "\code{_x_}" so that the
  three way interaction shown previously would generate a column named
  \code{A_x_B_x_C}. This can be changed using the \code{sep} argument.
}
\examples{
data(biomass)

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
              data = biomass_tr)

int_mod_1 <- rec \%>\%
  step_interact(terms = ~ carbon:hydrogen)

int_mod_2 <- int_mod_1 \%>\%
  step_interact(terms = ~ (oxygen + nitrogen + sulfur)^3)

int_mod_1 <- prep(int_mod_1, training = biomass_tr)
int_mod_2 <- prep(int_mod_2, training = biomass_tr)

dat_1 <- bake(int_mod_1, biomass_te)
dat_2 <- bake(int_mod_2, biomass_te)

names(dat_1)
names(dat_2)
}
\concept{
preprocessing model_specification
}
\keyword{datagen}
