% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{format_delim}
\alias{format_delim}
\alias{format_csv}
\alias{format_tsv}
\title{Convert a data frame to a delimited string}
\usage{
format_delim(x, delim, na = "NA", append = FALSE, col_names = !append)

format_csv(x, na = "NA", append = FALSE, col_names = !append)

format_tsv(x, na = "NA", append = FALSE, col_names = !append)
}
\arguments{
\item{x}{A data frame to write to disk}

\item{delim}{Delimiter used to separate values. Defaults to \code{" "}. Must be
a single character.}

\item{na}{String used for missing values. Defaults to NA. Missing values
will never be quoted; strings with the same value as \code{na} will
always be quoted.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if file does not exist a new
file is created.}

\item{col_names}{Write columns names at the top of the file?}
}
\value{
A string.
}
\description{
These functions are equivalent to \code{\link[=write_csv]{write_csv()}} etc., but instead
of writing to disk, they return a string.
}
\section{Output}{

Factors are coerced to character. Doubles are formatted using the grisu3
algorithm. POSIXct's are formatted as ISO8601.

All columns are encoded as UTF-8. \code{write_excel_csv()} also includes a
\href{https://en.wikipedia.org/wiki/Byte_order_mark}{UTF-8 Byte order mark}
which indicates to Excel the csv is UTF-8 encoded.

Values are only quoted if needed: if they contain a comma, quote or newline.
}

\references{
Florian Loitsch, Printing Floating-Point Numbers Quickly and
Accurately with Integers, PLDI '10,
\url{http://www.cs.tufts.edu/~nr/cs257/archive/florian-loitsch/printf.pdf}
}
