% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence.R
\name{rhat}
\alias{rhat}
\alias{rhat.default}
\alias{rhat.rvar}
\title{Rhat convergence diagnostic}
\usage{
rhat(x, ...)

\method{rhat}{default}(x, ...)

\method{rhat}{rvar}(x, ...)
}
\arguments{
\item{x}{(multiple options) One of:
\itemize{
\item A matrix of draws for a single variable (iterations x chains). See
\code{\link[=extract_variable_matrix]{extract_variable_matrix()}}.
\item An \code{\link{rvar}}.
}}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
If the input is an array, returns a single numeric value. If any of the draws
is non-finite, that is, \code{NA}, \code{NaN}, \code{Inf}, or \code{-Inf}, the returned output
will be (numeric) \code{NA}. Also, if all draws within any of the chains of a
variable are the same (constant), the returned output will be (numeric) \code{NA}
as well. The reason for the latter is that, for constant draws, we cannot
distinguish between variables that are supposed to be constant (e.g., a
diagonal element of a correlation matrix is always 1) or variables that just
happened to be constant because of a failure of convergence or other problems
in the sampling process.

If the input is an \code{\link{rvar}}, returns an array of the same dimensions as the
\code{\link{rvar}}, where each element is equal to the value that would be returned by
passing the draws array for that element of the \code{\link{rvar}} to this function.
}
\description{
Compute the Rhat convergence diagnostic for a single variable as the maximum
of rank normalized split-Rhat and rank normalized folded-split-Rhat as
proposed in Vehtari et al. (2021).
}
\examples{
mu <- extract_variable_matrix(example_draws(), "mu")
rhat(mu)

d <- as_draws_rvars(example_draws("multi_normal"))
rhat(d$Sigma)

}
\references{
Aki Vehtari, Andrew Gelman, Daniel Simpson, Bob Carpenter, and
Paul-Christian Bürkner (2021). Rank-normalization, folding, and
localization: An improved R-hat for assessing convergence of
MCMC (with discussion). \emph{Bayesian Data Analysis}. 16(2), 667-–718.
doi:10.1214/20-BA1221
}
\seealso{
Other diagnostics: 
\code{\link{ess_basic}()},
\code{\link{ess_bulk}()},
\code{\link{ess_quantile}()},
\code{\link{ess_sd}()},
\code{\link{ess_tail}()},
\code{\link{mcse_mean}()},
\code{\link{mcse_quantile}()},
\code{\link{mcse_sd}()},
\code{\link{pareto_diags}()},
\code{\link{pareto_khat}()},
\code{\link{rhat_basic}()},
\code{\link{rhat_nested}()},
\code{\link{rstar}()}
}
\concept{diagnostics}
