% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{render_notes}
\alias{render_notes}
\title{Renders rmarkdown Documents Using User Default Options}
\usage{
render_notes(input, output_format = NULL, output_options = NULL, ...,
  .config = NULL)
}
\arguments{
\item{input}{Input file (R script, Rmd, or plain markdown).}

\item{output_format}{R Markdown output format to convert to. Pass
  \code{"all"} to render all formats defined within the file. Pass
  the name of a format (e.g. \code{"html_document"}) to render a single
  format or pass a vector of format names to render multiple formats.
  Alternatively you can pass an output format object;
  e.g. \code{html_document()}. If \code{NULL} is passed then the
  output format is the first one defined in the YAML metadata of the
  input file (defaulting to HTML if none is specified).}

\item{output_options}{List of output options that can override the options
  specified in metadata (e.g. could be used to force \code{self_contained} or
  \code{mathjax = "local"}). Note that this is only valid when the output
  format is read from metadata (i.e. not a custom format object passed to
  \code{output_format}).}

\item{...}{other arguments passed to \code{\link[rmarkdown]{render}}}

\item{.config}{location of the default options (a YAML file).
Default behaviour is to look for file \code{'.rmarkdown.yaml'} in the user's
home directory, or, if missing, for a yaml section \code{rmarkdown::render}
in the user's R profile.}
}
\description{
Renders rmarkdown Documents Using User Default Options
}
\seealso{
\code{\link{read.yaml_section}}
}
