% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shaft.R, R/shaft-simple.R
\name{new_pillar_shaft}
\alias{new_pillar_shaft}
\alias{new_pillar_shaft_simple}
\title{Constructor for column data}
\usage{
new_pillar_shaft(x, ..., width, min_width = width, subclass)

new_pillar_shaft_simple(formatted, ..., width = NULL, align = "left",
  min_width = NULL, na_indent = 0L)
}
\arguments{
\item{x}{An object}

\item{...}{Additional attributes}

\item{width}{The maximum column width.}

\item{min_width}{The minimum allowed column width, \code{width} if omitted.}

\item{subclass}{The name of the subclass.}

\item{formatted}{An object coercible to \link{character}.}

\item{align}{Alignment of the column.}

\item{na_indent}{Indention of \code{NA} values.}
}
\description{
The \code{new_pillar_shaft()} constructor creates objects of the \code{"pillar_shaft"}
class.
This is a virtual or abstract class, you must specify the \code{subclass}
argument.
By convention, this should be a string that starts with \code{"pillar_shaft_"}.
See \code{vignette("extending", package = "tibble")} for usage examples.

\code{new_pillar_shaft_simple()} provides an implementation of the \code{pillar_shaft}
class suitable for output that has a fixed formatting, which will be
truncated with a continuation character (ellipsis or \code{~}) if it doesn't fit
the available width.
By default, the required width is computed from the natural width of the
\code{formatted} argument.
}
\details{
The \code{formatted} argument may also contain ANSI escapes to change color
or other attributes of the text, see \link{crayon}.
}
