% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.kmeans.R
\name{model_performance.kmeans}
\alias{model_performance.kmeans}
\title{Model summary for k-means clustering}
\usage{
\method{model_performance}{kmeans}(model, verbose = TRUE, ...)
}
\arguments{
\item{model}{Object of type \code{kmeans}.}

\item{verbose}{Toggle off warnings.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Model summary for k-means clustering
}
\examples{
# a 2-dimensional example
x <- rbind(
  matrix(rnorm(100, sd = 0.3), ncol = 2),
  matrix(rnorm(100, mean = 1, sd = 0.3), ncol = 2)
)
colnames(x) <- c("x", "y")
model <- kmeans(x, 2)
model_performance(model)
}
