% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_loadings.R
\name{reshape_loadings}
\alias{reshape_loadings}
\alias{reshape_loadings.parameters_efa}
\alias{reshape_loadings.data.frame}
\title{Reshape loadings between wide/long formats}
\usage{
reshape_loadings(x, ...)

\method{reshape_loadings}{parameters_efa}(x, threshold = NULL, ...)

\method{reshape_loadings}{data.frame}(x, threshold = NULL, loadings_columns = NULL, ...)
}
\arguments{
\item{x}{A data frame or a statistical model.}

\item{...}{Arguments passed to or from other methods.}

\item{threshold}{A value between 0 and 1 indicates which (absolute) values
from the loadings should be removed. An integer higher than 1 indicates the
n strongest loadings to retain. Can also be \code{"max"}, in which case it
will only display the maximum loading per variable (the most simple
structure).}

\item{loadings_columns}{Vector indicating the columns corresponding to loadings.}
}
\description{
Reshape loadings between wide/long formats.
}
\examples{
library(parameters)
library(psych)

pca <- model_parameters(psych::fa(attitude, nfactors = 3))
loadings <- reshape_loadings(pca)

loadings
reshape_loadings(loadings)
}
