% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Count.R
\name{Poisson_LogLoss}
\alias{Poisson_LogLoss}
\title{Poisson Log loss}
\usage{
Poisson_LogLoss(y_pred, y_true)
}
\arguments{
\item{y_pred}{Predicted labels vector, as returned by a model}

\item{y_true}{Ground truth (correct) labels vector}
}
\value{
Log loss/Cross-Entropy Loss
}
\description{
Compute the log loss/cross-entropy loss.
}
\examples{
d_AD <- data.frame(treatment = gl(3,3), outcome = gl(3,1,9),
                   counts = c(18,17,15,20,10,20,25,13,12))
glm_poisson <- glm(counts ~ outcome + treatment,
                   family = poisson(link = "log"), data = d_AD)
Poisson_LogLoss(y_pred = glm_poisson$fitted.values, y_true = d_AD$counts)
}

