% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostage.R
\name{survival.twostageCC}
\alias{survival.twostageCC}
\title{Twostage survival model for multivariate survival data}
\usage{
survival.twostageCC(
  margsurv,
  data = parent.frame(),
  method = "nr",
  Nit = 60,
  detail = 0,
  clusters = NULL,
  silent = 1,
  weights = NULL,
  control = list(),
  theta = NULL,
  theta.des = NULL,
  var.link = 1,
  baseline.iid = 1,
  step = 0.5,
  model = "clayton.oakes",
  marginal.trunc = NULL,
  marginal.survival = NULL,
  marginal.status = NULL,
  strata = NULL,
  se.clusters = NULL,
  numDeriv = 0,
  random.design = NULL,
  pairs = NULL,
  dim.theta = NULL,
  numDeriv.method = "simple",
  additive.gamma.sum = NULL,
  var.par = 1,
  cr.models = NULL,
  case.control = 0,
  ascertained = 0,
  shut.up = 0
)
}
\arguments{
\item{margsurv}{Marginal model}

\item{data}{data frame}

\item{method}{Scoring method "nr", "nlminb", "optimize", "nlm"}

\item{Nit}{Number of iterations}

\item{detail}{Detail}

\item{clusters}{Cluster variable}

\item{silent}{Debug information}

\item{weights}{Weights}

\item{control}{Optimization arguments}

\item{theta}{Starting values for variance components}

\item{theta.des}{design for dependence parameters, when pairs are given the indeces of the
theta-design for this pair, is given in pairs as column 5}

\item{var.link}{Link function for variance:  exp-link.}

\item{baseline.iid}{to adjust for baseline estimation, using phreg function on same data.}

\item{step}{Step size}

\item{model}{model}

\item{marginal.trunc}{marginal left truncation probabilities}

\item{marginal.survival}{optional vector of marginal survival probabilities}

\item{marginal.status}{related to marginal survival probabilities}

\item{strata}{strata for fitting, see example}

\item{se.clusters}{for clusters for se calculation with iid}

\item{numDeriv}{to get numDeriv version of second derivative, otherwise uses sum of squared score}

\item{random.design}{random effect design for additive gamma model, when pairs are given the
indeces of the pairs random.design rows are given as columns 3:4}

\item{pairs}{matrix with rows of indeces (two-columns) for the pairs considered in the pairwise
composite score, useful for case-control sampling when marginal is known.}

\item{dim.theta}{dimension of the theta parameter for pairs situation.}

\item{numDeriv.method}{uses simple to speed up things and second derivative not so important.}

\item{additive.gamma.sum}{for two.stage=0, this is specification of the lamtot in the models via
a matrix that is multiplied onto the parameters theta (dimensions=(number random effects x number
of theta parameters), when null then sums all parameters.}

\item{var.par}{is 1 for the default parametrization with the variances of the random effects,
var.par=0 specifies that the \eqn{\lambda_j}'s are used as parameters.}

\item{cr.models}{competing risks models for two.stage=0, should be given as a list with models for each cause}

\item{case.control}{assumes case control structure for "pairs" with second column being the probands,
when this options is used the twostage model is profiled out via the paired estimating equations for the survival model.}

\item{ascertained}{if the pair are sampled only when there is an event. This is in contrast to
case.control sampling where a proband is given. This can be combined with control probands. Pair-call
of twostage is needed  and second column of pairs are the first jump time with an event for ascertained pairs,
or time of control proband.}

\item{shut.up}{to make the program more silent in the context of iterative procedures for case-control}
}
\description{
older extended version of survival.twostage with  more options  and different maximizer.
}
\author{
Thomas Scheike
}
\keyword{survival}
