% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importQualtrics.R
\name{qualtricsBlockStack}
\alias{qualtricsBlockStack}
\title{Create meta data frame to align identical questions}
\usage{
qualtricsBlockStack(meta, questionname = "question")
}
\arguments{
\item{meta}{A meta data structure retrieved from importQualtrics}

\item{questionname}{Character string for name of column in meta data that holds the questions}
}
\value{
A new meta data table that horizontally aligns equivalent questions.
}
\description{
Qualtrics returns a data frame that has vertical "blocks", one for
each "treatment condition" in an experimental condition.
Researchers often want to align the questions from the blocks
vertically, essentially converting the Qualtrics "wide" format to
a "long" format. This is a helper function that identifies
questions that may need to be stacked together.  The input is a
meta data structure (can be retrieved as an attribute from
importQualtrics). It will find out which questions are identical
and prepare to re-align ("stack") the columns.
}
\author{
Paul Johnson
}
