% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{which_multiple}
\alias{which_multiple}
\alias{has.multiple}
\alias{is.loop}
\alias{is.multiple}
\alias{count.multiple}
\alias{count_multiple}
\alias{any_loop}
\alias{any_multiple}
\alias{which_loop}
\title{Find the multiple or loop edges in a graph}
\usage{
which_multiple(graph, eids = E(graph))
}
\arguments{
\item{graph}{The input graph.}

\item{eids}{The edges to which the query is restricted. By default this is
all edges in the graph.}
}
\value{
\code{any_loop()} and \code{any_multiple()} return a logical scalar.
\code{which_loop()} and \code{which_multiple()} return a logical vector.
\code{count_multiple()} returns a numeric vector.
}
\description{
A loop edge is an edge from a vertex to itself. An edge is a multiple edge
if it has exactly the same head and tail vertices as another edge. A graph
without multiple and loop edges is called a simple graph.
}
\details{
\code{any_loop()} decides whether the graph has any loop edges.

\code{which_loop()} decides whether the edges of the graph are loop edges.

\code{any_multiple()} decides whether the graph has any multiple edges.

\code{which_multiple()} decides whether the edges of the graph are multiple
edges.

\code{count_multiple()} counts the multiplicity of each edge of a graph.

Note that the semantics for \code{which_multiple()} and \code{count_multiple()} is
different. \code{which_multiple()} gives \code{TRUE} for all occurrences of a
multiple edge except for one. I.e. if there are three \code{i-j} edges in the
graph then \code{which_multiple()} returns \code{TRUE} for only two of them while
\code{count_multiple()} returns \sQuote{3} for all three.

See the examples for getting rid of multiple edges while keeping their
original multiplicity as an edge attribute.
}
\examples{

# Loops
g <- make_graph(c(1, 1, 2, 2, 3, 3, 4, 5))
any_loop(g)
which_loop(g)

# Multiple edges
g <- sample_pa(10, m = 3, algorithm = "bag")
any_multiple(g)
which_multiple(g)
count_multiple(g)
which_multiple(simplify(g))
all(count_multiple(simplify(g)) == 1)

# Direction of the edge is important
which_multiple(make_graph(c(1, 2, 2, 1)))
which_multiple(make_graph(c(1, 2, 2, 1), dir = FALSE))

# Remove multiple edges but keep multiplicity
g <- sample_pa(10, m = 3, algorithm = "bag")
E(g)$weight <- count_multiple(g)
g <- simplify(g, edge.attr.comb = list(weight = "min"))
any(which_multiple(g))
E(g)$weight

}
\seealso{
\code{\link[=simplify]{simplify()}} to eliminate loop and multiple edges.

Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{unfold_tree}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
