% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{membership}
\alias{membership}
\alias{communities}
\alias{algorithm}
\alias{crossing}
\alias{cutat}
\alias{merges}
\alias{sizes}
\alias{cut_at}
\alias{is.hierarchical}
\alias{print.communities}
\alias{plot.communities}
\alias{length.communities}
\alias{as.dendrogram.communities}
\alias{as.hclust.communities}
\alias{code_len}
\alias{asPhylo}
\alias{asPhylo.communities}
\alias{showtrace}
\alias{code.length}
\alias{as_phylo}
\alias{as_phylo.communities}
\alias{show_trace}
\alias{is_hierarchical}
\alias{print.communities}
\alias{modularity.communities}
\alias{length.communities}
\alias{sizes}
\alias{algorithm}
\alias{merges}
\alias{crossing}
\alias{code_len}
\alias{is_hierarchical}
\alias{as.dendrogram.communities}
\alias{as.hclust.communities}
\alias{as_phylo}
\alias{as_phylo.communities}
\alias{cut_at}
\alias{show_trace}
\alias{plot.communities}
\title{Functions to deal with the result of network community detection}
\usage{
membership(communities)

\method{print}{communities}(x, ...)

\method{modularity}{communities}(x, ...)

\method{length}{communities}(x)

sizes(communities)

algorithm(communities)

merges(communities)

crossing(communities, graph)

code_len(communities)

is_hierarchical(communities)

\method{as.dendrogram}{communities}(object, hang = -1,
  use.modularity = FALSE, ...)

\method{as.hclust}{communities}(x, hang = -1, use.modularity = FALSE, ...)

as_phylo(x, ...)

\method{as_phylo}{communities}(x, use.modularity = FALSE, ...)

cut_at(communities, no, steps)

show_trace(communities)

\method{plot}{communities}(x, y, col = membership(x),
  mark.groups = communities(x), edge.color = c("black", "red")[crossing(x,
  y) + 1], ...)
}
\arguments{
\item{communities, x, object}{A \code{communities} object, the result of an
igraph community detection function.}

\item{\dots}{Additional arguments. \code{plot.communities} passes these to
\code{\link{plot.igraph}}. The other functions silently ignore
them.}

\item{graph}{An igraph graph object, corresponding to \code{communities}.}

\item{hang}{Numeric scalar indicating how the height of leaves should be
computed from the heights of their parents; see \code{\link{plot.hclust}}.}

\item{use.modularity}{Logical scalar, whether to use the modularity values
to define the height of the branches.}

\item{no}{Integer scalar, the desired number of communities. If too low or
two high, then an error message is given. Exactly one of \code{no} and
\code{steps} must be supplied.}

\item{steps}{The number of merge operations to perform to produce the
communities. Exactly one of \code{no} and \code{steps} must be supplied.}

\item{y}{An igraph graph object, corresponding to the communities in
\code{x}.}

\item{col}{A vector of colors, in any format that is accepted by the regular
R plotting methods. This vector gives the colors of the vertices explicitly.}

\item{mark.groups}{A list of numeric vectors. The communities can be
highlighted using colored polygons. The groups for which the polygons are
drawn are given here. The default is to use the groups given by the
communities. Supply \code{NULL} here if you do not want to highlight any
groups.}

\item{edge.color}{The colors of the edges. By default the edges within
communities are colored green and other edges are red.}

\item{membership}{Numeric vector, one value for each vertex, the membership
vector of the community structure. Might also be \code{NULL} if the
community structure is given in another way, e.g. by a merge matrix.}

\item{algorithm}{If not \code{NULL} (meaning an unknown algorithm), then a
character scalar, the name of the algorithm that produced the community
structure.}

\item{merges}{If not \code{NULL}, then the merge matrix of the hierarchical
community structure. See \code{merges} below for more information on its
format.}

\item{modularity}{Numeric scalar or vector, the modularity value of the
community structure. It can also be \code{NULL}, if the modularity of the
(best) split is not available.}
}
\value{
\code{print} returns the \code{communities} object itself,
invisibly.

\code{length} returns an integer scalar.

\code{sizes} returns a numeric vector.

\code{membership} returns a numeric vector, one number for each vertex in
the graph that was the input of the community detection.

\code{modularity} returns a numeric scalar.

\code{algorithm} returns a character scalar.

\code{crossing} returns a logical vector.

\code{is_hierarchical} returns a logical scalar.

\code{merges} returns a two-column numeric matrix.

\code{cut_at} returns a numeric vector, the membership vector of the
vertices.

\code{as.dendrogram} returns a \code{\link[stats]{dendrogram}} object.

\code{show_trace} returns a character vector.

\code{code_len} returns a numeric scalar for communities found with the
InfoMAP method and \code{NULL} for other methods.

\code{plot} for \code{communities} objects returns \code{NULL}, invisibly.

#' @author Gabor Csardi \email{csardi.gabor@gmail.com}
}
\description{
igraph community detection functions return their results as an object from
the \code{communities} class. This manual page describes the operations of
this class.
}
\details{
Community structure detection algorithms try to find dense subgraphs in
directed or undirected graphs, by optimizing some criteria, and usually
using heuristics.

igraph implements a number of community detection methods (see them below),
all of which return an object of the class \code{communities}. Because the
community structure detection algorithms are different, \code{communities}
objects do not always have the same structure. Nevertheless, they have some
common operations, these are documented here.

The \code{print} generic function is defined for \code{communities}, it
prints a short summary.

The \code{length} generic function call be called on \code{communities} and
returns the number of communities.

The \code{sizes} function returns the community sizes, in the order of their
ids.

\code{membership} gives the division of the vertices, into communities. It
returns a numeric vector, one value for each vertex, the id of its
community. Community ids start from one. Note that some algorithms calculate
the complete (or incomplete) hierarchical structure of the communities, and
not just a single partitioning. For these algorithms typically the
membership for the highest modularity value is returned, but see also the
manual pages of the individual algorithms.

\code{communities} is also the name of a function, that returns a list of
communities, each identified by their vertices. The vertices will have
symbolic names if the \code{add.vertex.names} igraph option is set, and the
graph itself was named. Otherwise numeric vertex ids are used.

\code{modularity} gives the modularity score of the partitioning. (See
\code{\link{modularity.igraph}} for details. For algorithms that do not
result a single partitioning, the highest modularity value is returned.

\code{algorithm} gives the name of the algorithm that was used to calculate
the community structure.

\code{crossing} returns a logical vector, with one value for each edge,
ordered according to the edge ids. The value is \code{TRUE} iff the edge
connects two different communities, according to the (best) membership
vector, as returned by \code{membership()}.

\code{is_hierarchical} checks whether a hierarchical algorithm was used to
find the community structure. Some functions only make sense for
hierarchical methods (e.g. \code{merges}, \code{cut_at} and
\code{as.dendrogram}).

\code{merges} returns the merge matrix for hierarchical methods. An error
message is given, if a non-hierarchical method was used to find the
community structure. You can check this by calling \code{is_hierarchical} on
the \code{communities} object.

\code{cut_at} cuts the merge tree of a hierarchical community finding method,
at the desired place and returns a membership vector. The desired place can
be expressed as the desired number of communities or as the number of merge
steps to make. The function gives an error message, if called with a
non-hierarchical method.

\code{as.dendrogram} converts a hierarchical community structure to a
\code{dendrogram} object. It only works for hierarchical methods, and gives
an error message to others. See \code{\link[stats]{dendrogram}} for details.

\code{as.hclust} is similar to \code{as.dendrogram}, but converts a
hierarchical community structure to a \code{hclust} object.

\code{as_phylo} converts a hierarchical community structure to a \code{phylo}
object, you will need the \code{ape} package for this.

\code{show_trace} works (currently) only for communities found by the leading
eigenvector method (\code{\link{cluster_leading_eigen}}), and
returns a character vector that gives the steps performed by the algorithm
while finding the communities.

\code{code_len} is defined for the InfoMAP method
(\code{\link{cluster_infomap}} and returns the code length of the
partition.

It is possibly to call the \code{plot} function on \code{communities}
objects. This will plot the graph (and uses \code{\link{plot.igraph}}
internally), with the communities shown. By default it colores the vertices
according to their communities, and also marks the vertex groups
corresponding to the communities. It passes additional arguments to
\code{\link{plot.igraph}}, please see that and also
\code{\link{igraph.plotting}} on how to change the plot.
}
\examples{

karate <- make_graph("Zachary")
wc <- cluster_walktrap(karate)
modularity(wc)
membership(wc)
plot(wc, karate)

}
\seealso{
See \code{\link{plot_dendrogram}} for plotting community structure
dendrograms.

See \code{\link{compare}} for comparing two community structures
on the same graph.

The different methods for finding communities, they all return a
\code{communities} object: \code{\link{cluster_edge_betweenness}},
\code{\link{cluster_fast_greedy}},
\code{\link{cluster_label_prop}},
\code{\link{cluster_leading_eigen}},
\code{\link{cluster_louvain}}, \code{\link{cluster_optimal}},
\code{\link{cluster_spinglass}}, \code{\link{cluster_walktrap}}.
}
\keyword{graphs}
