% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-token.R
\name{oauth_token}
\alias{oauth_token}
\title{Create an OAuth token}
\usage{
oauth_token(
  access_token,
  token_type = "bearer",
  expires_in = NULL,
  refresh_token = NULL,
  ...,
  .date = Sys.time()
)
}
\arguments{
\item{access_token}{The access token used to authenticate request}

\item{token_type}{Type of token; only \code{"bearer"} is currently supported.}

\item{expires_in}{Number of seconds until token expires.}

\item{refresh_token}{Optional refresh token; if supplied, this can be
used to cheaply get a new access token when this one expires.}

\item{...}{Additional components returned by the endpoint}

\item{.date}{Date the request was made; used to convert the relative
\code{expires_in} to an absolute \code{expires_at}.}
}
\value{
An OAuth token: an S3 list with class \code{httr2_token}.
}
\description{
Creates a S3 object of class \verb{<httr2_token>} representing an OAuth token
returned from the access token endpoint.
}
\examples{
oauth_token("abcdef")
oauth_token("abcdef", expires_in = 3600)
oauth_token("abcdef", refresh_token = "ghijkl")
}
\seealso{
\code{\link[=oauth_token_cached]{oauth_token_cached()}} to use the token cache with a specified
OAuth flow.
}
