% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlTable_style_handlers.R
\name{getHtmlTableStyle}
\alias{getHtmlTableStyle}
\title{Get style options for object}
\usage{
getHtmlTableStyle(x)
}
\arguments{
\item{x}{The object intended for \code{\link[=htmlTable]{htmlTable()}}.}
}
\value{
A \code{list} if the attribute exists, otherwise \code{NULL}
}
\description{
A wrap around the \code{\link[base:attr]{base::attr()}} that retrieves the style
attribute used by \code{\link[=htmlTable]{htmlTable()}} (\code{htmlTable.style}).
}
\examples{
library(magrittr)

mx <- matrix(1:4, ncol = 2)
colnames(mx) <- LETTERS[1:2]
mx \%>\%
  addHtmlTableStyle(align = "l|r") \%>\%
  getHtmlTableStyle()
}
