% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hms.R
\name{hms}
\alias{hms}
\alias{new_hms}
\alias{is_hms}
\alias{as_hms}
\alias{as.POSIXct.hms}
\alias{as.POSIXlt.hms}
\alias{as.character.hms}
\alias{format.hms}
\alias{print.hms}
\title{A simple class for storing time-of-day values}
\usage{
hms(seconds = NULL, minutes = NULL, hours = NULL, days = NULL)

new_hms(x = numeric())

is_hms(x)

as_hms(x)

\method{as.POSIXct}{hms}(x, ...)

\method{as.POSIXlt}{hms}(x, ...)

\method{as.character}{hms}(x, ...)

\method{format}{hms}(x, ...)

\method{print}{hms}(x, ...)
}
\arguments{
\item{seconds, minutes, hours, days}{Time since midnight. No bounds checking is
performed.}

\item{x}{An object.}

\item{...}{additional arguments to be passed to or from methods.}
}
\description{
The values are stored as a \link{difftime} vector with a custom class,
and always with "seconds" as unit for robust coercion to numeric.
Supports construction from time values, coercion to and from
various data types, and formatting.  Can be used as a regular column in a
data frame.

\code{hms()} is a high-level constructor that accepts second, minute, hour and day components
as numeric vectors.

\code{new_hms()} is a low-level constructor that only checks that its input has the correct base type, \link{numeric}.

\code{is_hms()} checks if an object is of class \code{hms}.

\code{as_hms()} forwards to \code{\link[=vec_cast]{vec_cast()}}.
}
\details{
For \code{hms}, all arguments must have the same length or be
\code{NULL}.  Odd combinations (e.g., passing only \code{seconds} and
\code{hours} but not \code{minutes}) are rejected.

For arguments of type \link{POSIXct} and \link{POSIXlt}, \code{as_hms()} does not perform timezone
conversion.
Use \code{\link[lubridate:with_tz]{lubridate::with_tz()}} and \code{\link[lubridate:force_tz]{lubridate::force_tz()}} as necessary.
}
\examples{
hms(56, 34, 12)
hms()

new_hms(as.numeric(1:3))
# Supports numeric only!
try(new_hms(1:3))

as_hms(1)
as_hms("12:34:56")
as_hms(Sys.time())
as.POSIXct(hms(1))
data.frame(a = hms(1))
d <- data.frame(hours = 1:3)
d$hours <- hms(hours = d$hours)
d
}
