
## package: haplo.stats
## test script: haplo.glm

## settings
verbose=TRUE

require(haplo.stats)

Sys.setlocale("LC_ALL", "C")
Sys.getlocale()

## this is a dataset borrowed from a haplo.stats user
# it has problems with recessive trait, but runs fast on all examples

"data.test.glm" <- 
structure(.Data = list(c(1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,
	0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.)
, c(1., 2., 1., 2., 1., 1., 2., 1., 1., 2., 1., 2., 1., 1., 1., 1., 1., 2., 2.,	1., 1., 1., 2., 2., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 2., 2.,2., 2., 2., 1., 1., 1., 1., 1., 2., 2., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 2., 2., 1., 1., 1., 1., 1., 1., 2., 2., 1., 1.,
	1., 1., 2., 1., 2., 2., 1., 2., 1., 2., 1., 2., 2., 1., 2., 2., 2.,1., 1., 1., 1., 1., 2., 1., 2., 1., 1., 2., 1., 1., 1., 1., 1., 2.,	1., 1., 2., 2., 1., 2., 1., 1., 1., 2., 1., 2., 1., 2., 2., 1., 1.,1., 1., 2., 1., 2., 1., 2., 2., 1., 2., 1., 1., 2., 2., 1., 2., 2.,
	2., 1., 2., 2., 1., 2., 2., 1., 2., 1., 1., 2., 1., 1., 1., 1., 2.,2., 1., 1., 2., 1., 1., 2., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1.,	1., 1., 1., 2., 1., 1., 1., 1., 2., 1., 2., 1., 1., 1., 1., 2., 2.,1., 2., 1., 2., 2., 1., 2., 1., 1., 1., 2., 2., 1., 1., 1., 1., 2.,
	1., 1., 1., 1., 2., 2., 1., 2., 2., 2., 1., 1., 1., 2., 1., 1., 2.,1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 2., 2., 2., 1., 1., 1., 2.,	1., 2., 1., 2., 1., 2., 1., 2., 1., 1., 1., 1., 1., 1., 2., 2., 1.,2., 2., 2., 1., 1., 2., 1., 1., 1., 1., 1., 2., 2., 1., 1., 1., 2.,
	1., 1., 1., 2., 1., 1., 2., 1., 1., 1., 1., 2., 2., 1., 2., 1., 2.,1., 1., 1., 2., 1., 1., 1., 1., 2., 2., 1., 1., 2., 1., 2., 2., 1.,	1., 2., 1., 1., 1., 1., 1., 2., 1., 2., 1., 1., 2., 1., 2., 2., 2.,1., 1., 2., 1., 2., 1., 1., 1., 1., 1., 1., 2., 2., 1., 1., 2., 1.,
	1., 1., 1., 2., 2., 2., 1., 1., 1., 1., 2., 1., 2., 2., 2., 2., 2.,1., 1., 2., 1., 2., 1., 2., 1., 2., 1., 1., 1., 1., 1., 1., 2., 2.,	1., 2., 2., 1., 2., 2., 2., 1., 2., 1., 2., 2., 2., 1., 1., 1., 2.,1., 1., 2., 2., 2., 2., 1., 2., 2., 1., 2., 2., 1., 2., 1., 1., 1.,
	2., 1., 2., 2., 1., 2., 1., 1., 1., 1., 1., 1., 1.),
            c(1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 1., 0.,0., 1., 1., 1., 1., 1., 1., 0., 1., 1., 1., 1., 0., 1., 1., 1., 0.,	1., 1., 0., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 0.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 2., 1., 1., 1., 1., 0., 1., 1., 1., 1., 1., 1., 1.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,0., 1., 1., 1., 1., 1., 0., 1., 1., 1., 1., 1., 1.)
, c(1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 2., 1., 2., 1., 2., 1., 1., 1., 1.,	1., 2., 1., 2., 1., 2., 2., 1., 1., 1., 1., 1., 1., 2., 1., 1., 2.,	1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 2., 1., 1., 2., 1., 1.,2., 2., 1., 1., 1., 1., 1., 1., 1., 1., 2., 2., 1., 2., 1., 1., 1.,
	1., 1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 2.,1., 2., 2., 1., 1., 1., 2., 2., 1., 1., 2., 1., 2., 2., 1., 1., 1.,	1., 1., 1., 2., 1., 1., 2., 1., 2., 1., 2., 1., 1., 1., 1., 2., 1.,2., 1., 1., 1., 1., 2., 1., 1., 2., 1., 1., 1., 1., 1., 0., 1., 0.,
	0., 1., 1., 1., 1., 2., 1., 0., 1., 2., 1., 1., 0., 1., 1., 1., 0.,1., 2., 0., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 2., 1., 0.,	1., 1., 1., 1., 1., 2., 1., 2., 1., 2., 1., 1., 1., 1., 1., 2., 1.,1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1., 2.,
	1., 1., 1., 1., 2., 2., 1., 1., 2., 0., 2., 2., 1., 1., 2., 1., 1.,1., 1., 2., 1., 1., 1., 1., 2., 1., 1., 1., 2., 1., 1., 2., 1., 1.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1.,1., 1., 1., 1., 2., 2., 1., 1., 2., 1., 1., 2., 1., 1., 2., 2., 2.,
	1., 2., 1., 1., 1., 2., 2., 1., 1., 1., 2., 1., 1., 1., 1., 2., 1.,1., 1., 1., 1., 1., 2., 2., 2., 2., 1., 1., 1., 1., 1., 2., 1., 1.,	1., 2., 2., 1., 1., 1., 1., 1., 1., 2., 2., 2., 1., 1., 1., 1., 2.,1., 2., 1., 2., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 2., 2.,
	2., 2., 2., 2., 1., 1., 2., 1., 1., 1., 2., 2., 1., 1., 1., 2., 1.,1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 2., 1., 1., 1., 1., 1., 2.,	1., 1., 2., 1., 2., 1., 1., 2., 1., 1., 2., 1., 1., 1., 1., 1., 1.,1., 1., 2., 1., 2., 2., 2., 2., 1., 1., 1., 1., 1., 2., 1., 1., 1.,
	0., 2., 1., 1., 1., 1., 0., 1., 1., 1., 2., 2., 2.)
            , c(1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,1., 1., 1., 1., 2., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1.,	1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 2.,1., 1., 1., 1., 1., 1., 1., 0., 1., 1., 1., 1., 2., 1., 1., 1., 2.,
	1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,0., 1., 1., 1., 1., 1., 1., 0., 1., 1., 1., 2., 0., 0., 1., 1., 0.,	2., 1., 0., 1., 1., 1., 1., 1., 0., 1., 1., 2., 1., 1., 1., 2., 1.,2., 1., 2., 1., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 2., 2.,
	1., 1., 2., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 0., 1., 1., 2., 2., 1., 1., 1.,	1., 1., 1., 1., 0., 1., 2., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1.,1., 2., 1., 1., 1., 2., 1., 2., 1., 1., 1., 2., 1., 1., 1., 0., 1.,
	2., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1.,1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 2., 1., 1., 1.,	2., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2.,1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1., 1.,
	2., 1., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 2., 1., 1.,1., 1., 1., 1., 2., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1.,	1., 1., 1., 2., 1., 1., 1., 1., 1., 2., 1., 2., 1., 1., 1., 1., 1.,2., 1., 1., 2., 1., 1., 2., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1.,
	1., 2., 1., 2., 1., 1., 1., 1., 1., 2., 1., 1., 1., 1., 1., 1., 1.,0., 1., 1., 2., 1., 1., 0., 2., 1., 1., 1., 1., 1.)
, c(1., 2., 2., 2., 1., 1., 2., 2., 1., 2., 1., 1., 1., 1., 1., 2., 1., 2., 1.,	2., 1., 1., 1., 2., 1., 1., 1., 1., 1., 2., 2., 2., 1., 2., 2., 1.,2., 1., 1., 1., 1., 1., 2., 2., 2., 2., 2., 1., 1., 2., 2., 1., 1.,
	2., 1., 1., 1., 2., 2., 1., 2., 1., 1., 2., 1., 2., 1., 2., 1., 1.,2., 2., 1., 1., 2., 2., 1., 2., 2., 2., 2., 1., 2., 2., 1., 1., 1.,	1., 1., 1., 2., 1., 1., 2., 1., 1., 2., 1., 2., 1., 1., 1., 1., 2.,2., 1., 2., 2., 1., 1., 2., 0., 2., 2., 2., 2., 2., 1., 2., 1., 2.,
	1., 2., 1., 2., 2., 2., 1., 2., 1., 2., 1., 2., 1., 1., 1., 1., 2.,0., 1., 1., 2., 2., 2., 2., 0., 2., 2., 1., 2., 0., 0., 1., 2., 0.,	2., 1., 0., 1., 2., 1., 1., 1., 0., 2., 2., 2., 1., 1., 2., 2., 1.,2., 2., 2., 1., 0., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 2., 2.,
	1., 1., 2., 2., 2., 1., 1., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2.,1., 2., 2., 1., 1., 1., 1., 1., 2., 0., 2., 2., 2., 2., 2., 1., 2.,	1., 2., 2., 1., 0., 1., 2., 2., 2., 2., 1., 1., 2., 2., 1., 2., 2.,2., 2., 1., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 1., 1., 0., 2.,
	2., 2., 2., 2., 1., 1., 2., 1., 1., 2., 2., 1., 2., 2., 1., 1., 2.,1., 1., 1., 2., 2., 2., 1., 1., 1., 2., 2., 2., 2., 2., 2., 1., 1.,	2., 2., 1., 2., 1., 1., 2., 1., 2., 1., 2., 1., 1., 1., 1., 2., 2.,2., 2., 2., 2., 2., 2., 1., 1., 1., 1., 1., 1., 2., 1., 1., 2., 1.,
	2., 1., 1., 1., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 1.,1., 1., 1., 1., 2., 1., 1., 2., 1., 1., 1., 1., 2., 1., 2., 2., 1.,	1., 2., 2., 2., 2., 2., 1., 1., 2., 2., 2., 2., 2., 1., 2., 2., 1.,2., 2., 1., 2., 2., 2., 2., 2., 2., 1., 1., 1., 2., 1., 1., 2., 1.,
	2., 2., 2., 2., 1., 1., 2., 1., 2., 2., 1., 2., 2., 2., 1., 2., 1.,0., 2., 2., 2., 2., 2., 0., 2., 1., 2., 1., 1., 2.)
, c(2., 2., 1., 1., 2., 2., 1., 1., 2., 1., 1., 2., 2., 2., 1., 1., 2., 1., 2.,	1., 1., 2., 2., 1., 2., 2., 2., 2., 2., 2., 1., 1., 2., 1., 1., 2.,	1., 2., 2., 2., 2., 1., 1., 1., 1., 1., 1., 1., 2., 1., 1., 2., 2.,2., 2., 2., 2., 1., 1., 2., 1., 2., 2., 1., 2., 1., 2., 1., 1., 2.,
	1., 1., 1., 2., 1., 1., 2., 2., 1., 1., 1., 2., 1., 1., 1., 2., 1.,2., 1., 1., 1., 2., 2., 1., 1., 2., 1., 2., 1., 2., 2., 2., 2., 1.,	1., 2., 1., 1., 2., 2., 2., 2., 1., 1., 1., 1., 1., 2., 1., 2., 1.,2., 1., 2., 1., 1., 1., 2., 1., 2., 1., 2., 1., 2., 2., 1., 2., 1.,
	2., 2., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1., 2., 1., 2., 1., 1.,2., 1., 2., 2., 1., 2., 2., 1., 2., 1., 1., 1., 2., 2., 1., 1., 2.,	1., 2., 1., 2., 1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 1., 1.,2., 2., 1., 1., 1., 2., 2., 1., 1., 2., 2., 1., 2., 1., 1., 2., 1.,
	2., 1., 1., 2., 1., 1., 2., 2., 1., 1., 1., 1., 1., 1., 1., 1., 1.,2., 1., 1., 2., 1., 2., 1., 1., 1., 1., 1., 2., 1., 1., 2., 1., 1.,	1., 1., 2., 1., 1., 1., 1., 1., 1., 2., 1., 1., 2., 2., 2., 1., 2.,1., 1., 1., 1., 1., 2., 1., 2., 2., 1., 1., 2., 1., 1., 2., 2., 1.,
	2., 2., 2., 1., 1., 1., 2., 2., 1., 1., 1., 1., 1., 1., 1., 2., 2.,1., 1., 2., 1., 2., 2., 1., 2., 1., 2., 2., 2., 2., 2., 2., 1., 1.,	1., 1., 1., 2., 1., 1., 2., 2., 2., 2., 1., 1., 2., 2., 2., 2., 1.,1., 2., 2., 1., 2., 1., 1., 1., 1., 2., 1., 1., 1., 2., 1., 1., 1.,
	1., 2., 2., 1., 1., 2., 2., 1., 2., 2., 1., 1., 1., 2., 1., 1., 2.,2., 1., 1., 1., 1., 1., 2., 2., 1., 1., 1., 1., 1., 2., 1., 1., 1.,	2., 1., 2., 1., 1., 1., 1., 1., 1., 2., 1., 2., 1., 1., 2., 1., 2.,1., 1., 1., 1., 1., 2., 1., 1., 1., 2., 2., 1., 1., 1., 2., 1., 2.,
	1., 1., 1., 1., 1., 1., 2., 1., 2., 1., 1., 2., 1.)
, c(2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2.,	1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2.,2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2.,2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2.,
	2., 2., 2., 2., 1., 2., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2.,2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1.,	2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 1., 2., 1., 2., 2., 2., 1.,2., 1., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2.,
	2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 1., 2., 1., 2., 2., 2.,2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 1., 2., 2., 2., 2., 1., 2.,	1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 1.,2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2.,
	2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 1., 2., 2., 2.,2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2.,	2., 2., 2., 2., 1., 1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2.,1., 1., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 1.,
	2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2., 2.,2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 2.,	2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2., 2.,1., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 1., 2., 2.,
	1., 2., 2., 2., 1., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 1., 2.,2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2.,	2., 2., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2., 2.,2., 1., 2., 2., 1., 2., 2., 2., 2., 2., 2., 2., 2., 1., 2., 2., 2.,
	1., 2., 2., 1., 2., 2., 2., 1., 2., 2., 1., 2., 2.))
, names = c("y3", "sex3", "V19", "V20", "V29", "V30", "V35", "V36")
, row.names = c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14","15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26","27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38",
	"39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50",	"51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62",	"63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74",
	"75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86",	"87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98",	"99", "100", "101", "102", "103", "104", "105", "106", "107", "108",
	"109", "110", "111", "112", "113", "114", "115", "116", "117", "118","119", "120", "121", "122", "123", "124", "125", "126", "127", "128",	"129", "130", "131", "132", "133", "134", "135", "136", "137", "138",
	"139", "140", "141", "142", "143", "144", "145", "146", "147", "148","149", "150", "151", "152", "153", "154", "155", "156", "157", "158","159", "160", "161", "162", "163", "164", "165", "166", "167", "168",
	"169", "170", "171", "172", "173", "174", "175", "176", "177", "178","179", "180", "181", "182", "183", "184", "185", "186", "187", "188","189", "190", "191", "192", "193", "194", "195", "196", "197", "198",
	"199", "200", "201", "202", "203", "204", "205", "206", "207", "208","209", "210", "211", "212", "213", "214", "215", "216", "217", "218","219", "220", "221", "222", "223", "224", "225", "226", "227", "228",
	"229", "230", "231", "232", "233", "234", "235", "236", "237", "238","239", "240", "241", "242", "243", "244", "245", "246", "247", "248","249", "250", "251", "252", "253", "254", "255", "256", "257", "258",
	"259", "260", "261", "262", "263", "264", "265", "266", "267", "268","269", "270", "271", "272", "273", "274", "275", "276", "277", "278","279", "280", "281", "282", "283", "284", "285", "286", "287", "288",
	"289", "290", "291", "292", "293", "294", "295", "296", "297", "298","299", "300", "301", "302", "303", "304", "305", "306", "307", "308","309", "310", "311", "312", "313", "314", "315", "316", "317", "318",
	"319", "320", "321", "322", "323", "324", "325", "326", "327", "328","329", "330", "331", "332", "333", "334", "335", "336", "337", "338","339", "340", "341", "342", "343", "344", "345", "346", "347", "348",
	"349", "350", "351", "352", "353", "354", "355", "356", "357", "358","359", "360", "361", "362", "363", "364", "365", "366", "367", "368","369", "370", "371", "372", "373", "374", "375", "376", "377", "378",
	"379", "380", "381", "382", "383", "384", "385", "386", "387", "388","389", "390", "391", "392", "393", "394", "395", "396", "397", "398","399", "400", "401", "402", "403", "404", "405", "406", "407", "408",
	"409", "410", "411", "412", "413", "414", "415", "416", "417", "418","419", "420", "421", "422", "423"), class = "data.frame")


  if(verbose) cat("setting up data...\n")
  
  # prepare a short example dataset, labaled as '3' 
# ht3 <- source("dump.ht3.s"), this is now at top of file
  geno3 <- data.test.glm[,-(1:2)]
  sex3 <- data.test.glm$sex
  y3 <- data.test.glm$y3
  set.seed(10)
  rgaus3 <- ifelse(y3==1, rnorm(423, .5, 1), rnorm(423))
  
  label3<-c("M1","M2","M3")
  geno3<-setupGeno(geno3, miss.val=c(0,NA))
  my.data3<-data.frame(geno3=geno3, sex3=sex3, y3=y3,
                       gaus3=rgaus3, gaus3.100=rgaus3*100)

  
  # use freq.min as a guide for choosing minimum hap frequency
  freq.min3 <- 5/(2*nrow(geno3))

  
  # prepare the hla dataset,
     # runs a lot longer, and MS alleles don't all start w/ 1, 2...
  label <-c("DQB","DRB","B")

  data(hla.demo)
  
  y <- hla.demo$resp
  y.bin <- 1*(hla.demo$resp.cat=="low")
#  y.bin[2] <- NA
  geno <- as.matrix(hla.demo[,c(17,18,21:24)])
#  geno[1,] <- rep(NA, 6)  
  geno <- setupGeno(geno, miss.val=c(0,NA))

  # geno now has an attribute 'unique.alleles' which must be passed to
  # haplo.glm as allele.lev=attributes(geno)$unique.alleles, see below

  my.data <- data.frame(geno=geno, age=hla.demo$age, male=hla.demo$male,
                      y=y, y.bin=y.bin)

  seed <- c(17, 53, 1, 40, 37, 0, 62, 56, 5, 52, 12, 1)

  if(verbose) cat("regular haplo.glm, additive genetic trait, and \n")
  set.seed(seed)
  fit3.add <- haplo.glm(y3~geno3, family=binomial,na.action="na.geno.keep",
               data=my.data3, locus.label=label3, miss.val = c(0, NA),
               method = "glm.fit", model = FALSE, x = FALSE, y = TRUE, contrasts = NULL,
               control = haplo.glm.control(haplo.freq.min=freq.min3, haplo.effect="add",
                 haplo.base = NULL, sum.rare.min = 0.001,
                 haplo.min.info = 0.001,keep.rare.haplo = TRUE, 
                 glm.c = glm.control(maxit = 500), em.c = haplo.em.control()))

 
  if(verbose) cat("binomial w/ dominant trait with gender\n")
  set.seed(seed)
  fit3.dom<-haplo.glm(y3~geno3, family=binomial, na.action="na.geno.keep",
                    data=my.data3, locus.label=label3, control =
                    haplo.glm.control(haplo.effect="dominant", haplo.min.count=8))
  set.seed(seed)
  fit3.dom.rare<-haplo.glm(y3~geno3, family=binomial, na.action="na.geno.keep",
                    data=my.data3, locus.label=label3, control =
                    haplo.glm.control(haplo.base=2,haplo.effect="dominant", haplo.freq.min=.32))

  if(verbose) cat("binomial with recessive trait\n")
  set.seed(seed)
  fit3.rec<-haplo.glm(y3~geno3, family=binomial, na.action="na.geno.keep",
                    data=my.data3, locus.label=label3,
                    control = haplo.glm.control(haplo.min.count=8,
                                      haplo.effect="recessive"))


if(verbose) cat("random gaussian, variance 1 and 100^2 \n")
  set.seed(seed)
  fit3.gaus <- haplo.glm(gaus3 ~ geno3, family=gaussian, na.action="na.geno.keep",
                    data=my.data3, locus.label=label3,
                    control = haplo.glm.control(haplo.min.count=8))

  set.seed(seed)
  # for version 1.3.9 and later, use the haplo.glm.q in /Haplo/Test/GlmSE/
  fit3.gaus100 <- haplo.glm(gaus3.100 ~ geno3, family=gaussian, na.action="na.geno.keep",
                    data=my.data3, locus.label=label3,
                    control = haplo.glm.control(haplo.min.count=8))
  
  
if(verbose) cat("fit a binary trait\n")
set.seed(seed)
fit.hla.bin <- haplo.glm(y.bin ~ male + geno, family = binomial,
                 na.action="na.geno.keep", data=my.data, locus.label=label,
                 control = haplo.glm.control(haplo.min.count=8))

y.bin <- 1*(hla.demo$resp.cat=="low")
y.bin[2] <- NA
geno.hla <- as.matrix(hla.demo[,c(17,18,21:24)])
geno.hla[2,5] <- 2
geno.hla[3,] <- rep(NA, 6)
geno.hla <- setupGeno(geno.hla, miss.val=c(0,NA))

my.hla <- data.frame(geno.hla=geno.hla, age=hla.demo$age, male=hla.demo$male,
                     y=y, y.bin=y.bin)

set.seed(seed)
fit.hla.miss <- haplo.glm(y.bin ~ male + geno.hla, family = binomial,
                     na.action="na.geno.keep",
                     data=my.hla, locus.label=label,
                     control = haplo.glm.control(haplo.min.count=8))
  
if(verbose) cat(" gaussian with covariates, additive\n")

set.seed(seed)
fit.hla.gaus.gender <- haplo.glm(y ~ male + geno, family = gaussian,
                 na.action="na.geno.keep",
                 data=my.data, locus.label=label,
                 control = haplo.glm.control(haplo.min.count=5))

if(verbose) cat("gaussian with covariate, multiplicative\n")
set.seed(seed)
fit.hla.gaus.inter <- haplo.glm(y ~ male * geno, family = gaussian,
                   na.action="na.geno.keep", data=my.data, locus.label=label,
                   control = haplo.glm.control(haplo.freq.min = 0.02))
  
if(verbose) cat("SNAP data with resp and resp with added variance\n")
   snapDF <- read.table("snapData.csv",header=TRUE, sep=",", stringsAsFactors=FALSE)

   geno.rec <- setupGeno(snapDF[,-c(1:9)])
   snap.data <- data.frame(resp=hla.demo$resp, respvar=hla.demo$resp*100, geno=geno.rec)

   set.seed(seed)
   fit.resp.hla <- haplo.glm(resp~geno, trait.type="gaussian",data=snap.data)

   set.seed(seed)
   fit.respvar.hla <- haplo.glm(respvar~geno, trait.type="gaussian",data=snap.data)
  


  print.haplo.glm(fit3.add,print.all.haplo=TRUE, digits=4)
  print.haplo.glm(fit3.dom, print.all.haplo=FALSE, digits=5)
  print.haplo.glm(fit3.dom.rare, print.all.haplo=FALSE, digits=5)
  print.haplo.glm(fit3.rec, print.all.haplo=FALSE, digits=5)
  print.haplo.glm(fit3.gaus, print.all.haplo=FALSE, digits=5)
  print.haplo.glm(fit3.gaus100, print.all.haplo=FALSE, digits=5)
  print.haplo.glm(fit.hla.bin, digits=5, print.all.haplo=FALSE)
  print.haplo.glm(fit.hla.miss, digits=5, print.all.haplo=FALSE)
  print.haplo.glm(fit.hla.gaus.gender, print.all.haplo=FALSE, digits=5)
  print.haplo.glm(fit.hla.gaus.inter, digits=5, print.all.haplo=FALSE)
  print.haplo.glm(fit.resp.hla, digits=5)
  print.haplo.glm(fit.respvar.hla, digits=5)
  
