% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.R
\name{branch_target}
\alias{branch_target}
\title{Get target (sha) pointed to by a branch}
\usage{
branch_target(branch = NULL)
}
\arguments{
\item{branch}{The branch}
}
\value{
sha or NA if not a direct reference
}
\description{
Get target (sha) pointed to by a branch
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Config user and commit a file
config(repo, user.name = "Alice", user.email = "alice@example.org")
lines <- "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do"
writeLines(lines, file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Get target (sha) pointed to by 'master' branch
branch_target(repository_head(repo))
}
}
