% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer_lines.R
\name{layer_lines}
\alias{layer_lines}
\title{Layer lines on a plot.}
\usage{
layer_lines(vis, ...)
}
\arguments{
\item{vis}{Visualisation to modify.}

\item{...}{Visual properties.}
}
\description{
\code{layer_lines} differs from \code{layer_paths} in that \code{layer_lines}
sorts the data on the x variable, so the line will always proceed from left
to right, whereas \code{layer_paths} will draw a line in whatever order
appears in the data.
}
\examples{
mtcars \%>\% ggvis(~wt, ~mpg, stroke = ~factor(cyl)) \%>\% layer_lines()

# Equivalent to
mtcars \%>\% ggvis(~wt, ~mpg, stroke = ~factor(cyl)) \%>\%
  group_by(cyl) \%>\% dplyr::arrange(wt) \%>\% layer_paths()
}
\seealso{
\code{\link{layer_paths}}
}
