% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-flow.r
\name{stat_flow}
\alias{stat_flow}
\title{Flow positions}
\usage{
stat_flow(
  mapping = NULL,
  data = NULL,
  geom = "flow",
  position = "identity",
  decreasing = NULL,
  reverse = NULL,
  absolute = NULL,
  discern = FALSE,
  negate.strata = NULL,
  aes.bind = NULL,
  infer.label = FALSE,
  min.y = NULL,
  max.y = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data;
override the default.}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{decreasing}{Logical; whether to arrange the strata at each axis
in the order of the variable values (\code{NA}, the default),
in ascending order of totals (largest on top, \code{FALSE}), or
in descending order of totals (largest on bottom, \code{TRUE}).}

\item{reverse}{Logical; if \code{decreasing} is \code{NA},
whether to arrange the strata at each axis
in the reverse order of the variable values,
so that they match the order of the values in the legend.
Ignored if \code{decreasing} is not \code{NA}.
Defaults to \code{TRUE}.}

\item{absolute}{Logical; if some cases or strata are negative,
whether to arrange them (respecting \code{decreasing} and \code{reverse})
using negative or absolute values of \code{y}.}

\item{discern}{Passed to \code{\link[=to_lodes_form]{to_lodes_form()}} if \code{data} is in
alluvia format.}

\item{negate.strata}{A vector of values of the \code{stratum} aesthetic to be
treated as negative (will ignore missing values with a warning).}

\item{aes.bind}{At what grouping level, if any, to prioritize differentiation
aesthetics when ordering the lodes within each stratum. Defaults to
\code{"none"} (no aesthetic binding) with intermediate option \code{"flows"} to bind
aesthetics after stratifying by axes linked to the index axis (the one
adjacent axis in \code{stat_flow()}; all remaining axes in \code{stat_alluvium()})
and strongest option \code{"alluvia"} to bind aesthetics after stratifying by
the index axis but before stratifying by linked axes (only available for
\code{stat_alluvium()}). Stratification by any axis is done with respect to the
strata at that axis, after separating positive and negative strata,
consistent with the values of \code{decreasing}, \code{reverse}, and \code{absolute}.
Thus, if \code{"none"}, then lode orderings will not depend on aesthetic
variables. All aesthetic variables are used, in the order in which they are
specified in \code{aes()}.}

\item{infer.label}{Logical; whether to assign the \code{stratum} or \code{alluvium}
variable to the \code{label} aesthetic. Defaults to \code{FALSE}, and requires that
no \code{label} aesthetic is assigned. This parameter is intended for use only
with data in alluva form, which are converted to lode form before the
statistical transformation. Deprecated; use
\code{\link[ggplot2:aes_eval]{ggplot2::after_stat()}} instead.}

\item{min.y, max.y}{Numeric; bounds on the heights of the strata to be
rendered. Use these bounds to exclude strata outside a certain range, for
example when labeling strata using \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}}.}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:layer]{ggplot2::layer()}}.}
}
\description{
Given a dataset with alluvial structure, \code{stat_flow} calculates the centroids
(\code{x} and \code{y}) and heights (\code{ymin} and \code{ymax}) of the flows between each pair
of adjacent axes.
}
\section{Aesthetics}{

\code{stat_alluvium}, \code{stat_flow}, and \code{stat_stratum} require one
of two sets of aesthetics:
\itemize{
\item \strong{\code{x}} and at least one of \strong{\code{alluvium}} and \strong{\code{stratum}}
\item any number of \strong{\verb{axis[0-9]*}} (\code{axis1}, \code{axis2}, etc.)
}

Use \code{x}, \code{alluvium}, and/or \code{stratum} for data in lodes format
and \verb{axis[0-9]*} for data in alluvia format (see \code{\link{alluvial-data}}).
Arguments to parameters inconsistent with the format will be ignored.
Additionally, each \verb{stat_*()} accepts the following optional
aesthetics:
\itemize{
\item \code{y}
\item \code{weight}
\item \code{order}
\item \code{group}
\item \code{label}
}

\code{y} controls the heights of the alluvia,
and may be aggregated across equivalent observations.
\code{weight} applies to the computed variables (see that section below)
but does not affect the positional aesthetics.
\code{order}, recognized by \code{stat_alluvium()} and \code{stat_flow()}, is used to
arrange the lodes within each stratum. It tolerates duplicates and takes
precedence over the differentiation aesthetics (when \code{aes.bind} is not
\code{"none"}) and lode guidance with respect to the remaining axes. (It replaces
the deprecated parameter \code{lode.ordering}.)
\code{group} is used internally; arguments are ignored.
\code{label} is used to label the strata or lodes and must take a unique value
across the observations within each stratum or lode.

These and any other aesthetics are aggregated as follows:
Numeric aesthetics, including \code{y}, are summed.
Character and factor aesthetics, including \code{label},
are assigned to strata or lodes provided they take unique values across the
observations within each (and are otherwise assigned \code{NA}).
}

\section{Computed variables}{
 These can be used with
\code{\link[ggplot2:aes_eval]{ggplot2::after_stat()}} to \href{https://ggplot2.tidyverse.org/reference/aes_eval.html}{control aesthetic evaluation}.
\describe{
\item{\code{n}}{number of cases in lode}
\item{\code{count}}{cumulative weight of lode}
\item{\code{prop}}{weighted proportion of lode}
\item{\code{stratum}}{value of variable used to define strata}
\item{\code{deposit}}{order in which (signed) strata are deposited}
\item{\code{lode}}{lode label distilled from alluvia
(\code{stat_alluvium()} and \code{stat_flow()} only)}
\item{\code{flow}}{direction of flow \code{"to"} or \code{"from"} from its axis
(\code{stat_flow()} only)}
}
The numerical variables \code{n}, \code{count}, and \code{prop} are calculated after the
data are grouped by \code{x} and weighted by \code{weight} (in addition to \code{y}).
The integer variable \code{deposit} is used internally to sort the data before
calculating heights. The character variable \code{lode} is obtained from
\code{alluvium} according to \code{distill}.
}

\section{Package options}{

\code{stat_stratum}, \code{stat_alluvium}, and \code{stat_flow} order strata and lodes
according to the values of several parameters, which must be held fixed
across every layer in an alluvial plot. These package-specific options set
global values for these parameters that will be defaulted to when not
manually set:
\itemize{
\item \code{ggalluvial.decreasing} (each \verb{stat_*}): defaults to \code{NA}.
\item \code{ggalluvial.reverse} (each \verb{stat_*}): defaults to \code{TRUE}.
\item \code{ggalluvial.absolute} (each \verb{stat_*}): defaults to \code{TRUE}.
\item \code{ggalluvial.cement.alluvia} (\code{stat_alluvium}): defaults to \code{FALSE}.
\item \code{ggalluvial.lode.guidance} (\code{stat_alluvium}): defaults to \code{"zigzag"}.
\item \code{ggalluvial.aes.bind} (\code{stat_alluvium} and \code{stat_flow}): defaults to
\code{"none"}.
}

See \code{\link[base:options]{base::options()}} for how to use options.
}

\section{Defunct parameters}{

The previously defunct parameters \code{weight} and \code{aggregate.wts} have been
discontinued. Use \code{y} and \code{cement.alluvia} instead.
}

\examples{
# illustrate positioning
ggplot(as.data.frame(Titanic),
       aes(y = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age,
           color = Survived)) +
  stat_stratum(geom = "errorbar") +
  geom_line(stat = "flow") +
  stat_flow(geom = "pointrange") +
  geom_text(stat = "stratum", aes(label = after_stat(stratum))) +
  scale_x_discrete(limits = c("Class", "Sex", "Age"))

# alluvium--flow comparison
data(vaccinations)
gg <- ggplot(vaccinations,
             aes(x = survey, stratum = response, alluvium = subject,
                 y = freq, fill = response)) +
  geom_stratum(alpha = .5) +
  geom_text(aes(label = response), stat = "stratum")
# rightward alluvial aesthetics for vaccine survey data
gg + geom_flow(stat = "alluvium", lode.guidance = "forward")
# memoryless flows for vaccine survey data
gg + geom_flow()

# size filter examples
gg <- ggplot(vaccinations,
       aes(y = freq,
           x = survey, stratum = response, alluvium = subject,
           fill = response, label = response)) +
  stat_stratum(alpha = .5) +
  geom_text(stat = "stratum")
# omit small flows
gg + geom_flow(min.y = 50)
# omit large flows
gg + geom_flow(max.y = 100)

# negate missing entries
ggplot(vaccinations,
       aes(y = freq,
           x = survey, stratum = response, alluvium = subject,
           fill = response, label = response,
           alpha = response != "Missing")) +
  stat_stratum(negate.strata = "Missing") +
  geom_flow(negate.strata = "Missing") +
  geom_text(stat = "stratum", alpha = 1, negate.strata = "Missing") +
  scale_alpha_discrete(range = c(.2, .6)) +
  guides(alpha = "none")

\donttest{
# aesthetics that vary betwween and within strata
data(vaccinations)
vaccinations$subgroup <- LETTERS[1:2][rbinom(
  n = length(unique(vaccinations$subject)), size = 1, prob = .5
) + 1][vaccinations$subject]
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           y = freq, fill = response, label = response)) +
  geom_flow(aes(alpha = subgroup)) +
  scale_alpha_discrete(range = c(1/3, 2/3)) +
  geom_stratum(alpha = .5) +
  geom_text(stat = "stratum")
# can even set aesthetics that vary both ways
ggplot(vaccinations,
       aes(x = survey, stratum = response, alluvium = subject,
           y = freq, label = response)) +
  geom_flow(aes(fill = interaction(response, subgroup)), aes.bind = "flows") +
  scale_alpha_discrete(range = c(1/3, 2/3)) +
  geom_stratum(alpha = .5) +
  geom_text(stat = "stratum")
}
}
\seealso{
\code{\link[ggplot2:layer]{ggplot2::layer()}} for additional arguments and
\code{\link[=geom_alluvium]{geom_alluvium()}} and
\code{\link[=geom_flow]{geom_flow()}} for the corresponding geoms.

Other alluvial stat layers: 
\code{\link{stat_alluvium}()},
\code{\link{stat_stratum}()}
}
\concept{alluvial stat layers}
