% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/border_fix.R
\name{fix_border_issues}
\alias{fix_border_issues}
\title{Fix border issues when cell are merged}
\usage{
fix_border_issues(x, part = "all")
}
\arguments{
\item{x}{flextable object}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
When cells are merged, the rendered borders will be those
of the first cell. If a column is made of three merged cells, the bottom
border that will be seen will be the bottom border of the first cell in the
column. From a user point of view, this is wrong, the bottom should be the one
defined for cell 3. This function modify the border values to avoid that effect.
}
\examples{
library(officer)
dat <- data.frame(a = 1:5, b = 6:10)
ft <- flextable(dat)
  ft <- theme_box(ft)
  ft <- merge_at(ft, i = 4:5, j = 1, part = "body")
  ft <- hline(ft, i = 5, part = "body",
        border = fp_border(color = "red", width = 5) )
print(ft)
ft <- fix_border_issues(ft)
print(ft)
}
