% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Render Markdown into email}
\usage{
render(
  msg,
  input,
  params = NULL,
  squish = TRUE,
  css_files = c(),
  include_css = c("rmd", "bootstrap", "highlight"),
  language = FALSE,
  interpolate = TRUE,
  .open = "{{",
  .close = "}}",
  .envir = NULL
)
}
\arguments{
\item{msg}{A message object.}

\item{input}{The input Markdown file to be rendered or a character vector of Markdown text.}

\item{params}{A list of named parameters that override custom parameters specified in the YAML front-matter.}

\item{squish}{Whether to clean up whitespace in rendered document.}

\item{css_files}{Extra CSS files.}

\item{include_css}{Whether to include rendered CSS from various sources (\code{"rmd"} — native R Markdown CSS; \code{"bootstrap"} — Bootstrap CSS; \code{"highlight"} — highlight.js CSS).}

\item{language}{Langauge of content. If \code{FALSE} then will not include
language field. If \code{TRUE} then will attempt to auto-detect language.
Otherwise will use the specified language.}

\item{interpolate}{Whether or not to interpolate into input using \link[glue]{glue}.}

\item{.open}{The opening delimiter.}

\item{.close}{The closing delimiter.}

\item{.envir}{Environment used for \code{glue} interpolation. Defaults to \code{parent.frame()}.}
}
\value{
A message object.
}
\description{
Render either Plain Markdown or R Markdown directly into the body of an email.

If \code{input} is a file then it will be interpreted as R Markdown it its
extension is either \code{"Rmd"} or \code{"Rmarkdown"}. Otherwise it will be
processed as Plain Markdown.
}
\section{Plain Markdown}{


Plain Markdown is processed with \code{\link[commonmark:commonmark]{commonmark::markdown_html()}}.
}

\section{R Markdown}{


R Markdown is processed with \code{\link[rmarkdown:render]{rmarkdown::render()}}.

Regardless of what \code{output} type is specified in the input file,
\code{render()} will always use the \code{"html_document"} output format.
}

\examples{

# Plain Markdown

markdown <- "[This](https://www.google.com) is a link."
filename <- "message.md"

# Render from Markdown in character vector.
msg <- envelope() \%>\% render(markdown)

# Create a file containing Markdown
cat(markdown, file = filename)

# Render from Markdown in file.
msg <- envelope() \%>\% render(filename)

# Cleanup.
file.remove(filename)

# R Markdown

filename <- "gh-doc.Rmd"

# Create an Rmd document from template.
rmarkdown::draft(
  filename,
  template = "github_document",
  package = "rmarkdown",
  edit = FALSE
)

# Check for suitable version of Pandoc (https://pandoc.org/).
#
# Need to have version 2.0 or greater to support required --quiet option.
#
pandoc <- rmarkdown::find_pandoc()
suitable_pandoc <- !is.null(pandoc$dir) && grepl("^2", pandoc$version)

# Render from Rmd file.
if (suitable_pandoc) {
  msg <- envelope() \%>\%
    render(filename, include_css = c("rmd", "highlight"))
}

# Cleanup.
file.remove(filename)
}
\seealso{
\code{\link{text}}, \code{\link{html}}
}
