% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{summarise}
\alias{summarise}
\alias{summarize}
\title{Reduce multiple values down to a single value}
\usage{
summarise(.data, ...)

summarize(.data, ...)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link[=tbl_df]{tbl_df()}}, \code{\link[dtplyr:tbl_dt]{dtplyr::tbl_dt()}} and \code{\link[dbplyr:tbl_dbi]{dbplyr::tbl_dbi()}}.}

\item{...}{Name-value pairs of summary functions. The name will be the
name of the variable in the result. The value should be an expression
that returns a single value like \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.

The arguments in \code{...} are automatically \link[rlang:quo]{quoted} and
\link[rlang:eval_tidy]{evaluated} in the context of the data
frame. They support \link[rlang:quasiquotation]{unquoting} and
splicing. See \code{vignette("programming")} for an introduction to
these concepts.}
}
\value{
An object of the same class as \code{.data}. One grouping level will
be dropped.
}
\description{
Create one or more scalar variables summarizing the variables of an
existing tbl. Tbls with groups created by \code{\link[=group_by]{group_by()}} will result in one
row in the output for each group.  Tbls with no groups will result in one row.
}
\details{
\code{summarise()} and \code{summarize()} are synonyms.
}
\section{Useful functions}{

\itemize{
\item Center: \code{\link[=mean]{mean()}}, \code{\link[=median]{median()}}
\item Spread: \code{\link[=sd]{sd()}}, \code{\link[=IQR]{IQR()}}, \code{\link[=mad]{mad()}}
\item Range: \code{\link[=min]{min()}}, \code{\link[=max]{max()}}, \code{\link[=quantile]{quantile()}}
\item Position: \code{\link[=first]{first()}}, \code{\link[=last]{last()}}, \code{\link[=nth]{nth()}},
\item Count: \code{\link[=n]{n()}}, \code{\link[=n_distinct]{n_distinct()}}
\item Logical: \code{\link[=any]{any()}}, \code{\link[=all]{all()}}
}
}

\section{Backend variations}{


The data frame backend supports creating a variable and using it in the
same summary. This means that previously created summary variables can be
further transformed or combined within the summary, as in \code{\link[=mutate]{mutate()}}.
However, it also means that summary variables with the same names as previous
variables overwrite them, making those variables unavailable to later summary
variables.

This behaviour may not be supported in other backends. To avoid unexpected
results, consider using new names for your summary variables, especially when
creating multiple summaries.
}

\section{Tidy data}{

When applied to a data frame, row names are silently dropped. To preserve,
convert to an explicit variable with \code{\link[tibble:rownames_to_column]{tibble::rownames_to_column()}}.
}

\examples{
# A summary applied to ungrouped tbl returns a single row
mtcars \%>\%
  summarise(mean = mean(disp), n = n())

# Usually, you'll want to group first
mtcars \%>\%
  group_by(cyl) \%>\%
  summarise(mean = mean(disp), n = n())

# Each summary call removes one grouping level (since that group
# is now just a single row)
mtcars \%>\%
  group_by(cyl, vs) \%>\%
  summarise(cyl_n = n()) \%>\%
  group_vars()


# Reusing variable names when summarising may lead to unexpected results
mtcars \%>\%
  group_by(cyl) \%>\%
  summarise(disp = mean(disp), sd = sd(disp), double_disp = disp * 2)


# Refer to column names stored as strings with the `.data` pronoun:
var <- "mass"
summarise(starwars, avg = mean(.data[[var]], na.rm = TRUE))

# For more complex cases, knowledge of tidy evaluation and the
# unquote operator `!!` is required. See https://tidyeval.tidyverse.org/
#
# One useful and simple tidy eval technique is to use `!!` to
# bypass the data frame and its columns. Here is how to divide the
# column `mass` by an object of the same name:
mass <- 100
summarise(starwars, avg = mean(mass / !!mass, na.rm = TRUE))
}
\seealso{
Other single table verbs: \code{\link{arrange}},
  \code{\link{filter}}, \code{\link{mutate}},
  \code{\link{select}}, \code{\link{slice}}
}
\concept{single table verbs}
