% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_histogram.R
\name{get_degree_histogram}
\alias{get_degree_histogram}
\title{Get histogram data for a graph's degree frequency}
\usage{
get_degree_histogram(graph, mode = "total")
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{mode}{using \code{total} (the default), degree considered for each node
will be the total degree. With \verb{in} and \code{out} the degree used
will be the in-degree and out-degree, respectively.}
}
\value{
A data frame with degree counts.
}
\description{
Get histogram data for a graph's degree frequency. The bin width is set to 1
and zero-value degrees are omitted from the output.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get degree histogram data for
# the graph (reporting total degree)
graph \%>\%
  get_degree_histogram(
    mode = "total")

}
