% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R, R/unnormalize.R
\name{normalize}
\alias{normalize}
\alias{normalize.numeric}
\alias{normalize.data.frame}
\alias{unnormalize}
\alias{unnormalize.numeric}
\alias{unnormalize.data.frame}
\alias{unnormalize.grouped_df}
\title{Normalize numeric variable to 0-1 range}
\usage{
normalize(x, ...)

\method{normalize}{numeric}(x, include_bounds = TRUE, verbose = TRUE, ...)

\method{normalize}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  include_bounds = TRUE,
  append = FALSE,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)

unnormalize(x, ...)

\method{unnormalize}{numeric}(x, verbose = TRUE, ...)

\method{unnormalize}{data.frame}(
  x,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)

\method{unnormalize}{grouped_df}(
  x,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric vector, (grouped) data frame, or matrix. See 'Details'.}

\item{...}{Arguments passed to or from other methods.}

\item{include_bounds}{Numeric or logical. Using this can be useful in case of
beta-regression, where the response variable is not allowed to include
zeros and ones. If \code{TRUE}, the input is normalized to a range that includes
zero and one. If \code{FALSE}, the return value is compressed, using
Smithson and Verkuilen's (2006) formula \code{(x * (n - 1) + 0.5) / n}, to avoid
zeros and ones in the normalized variables. Else, if numeric (e.g., \code{0.001}),
\code{include_bounds} defines the "distance" to the lower and upper bound, i.e.
the normalized vectors are rescaled to a range from \code{0 + include_bounds} to
\code{1 - include_bounds}.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with()}, \code{ends_with()},
\code{contains()}, a range using \code{:} or \code{regex("")}. \code{starts_with()},
\code{ends_with()}, and  \code{contains()} accept several patterns, e.g
\code{starts_with("Sep", "Petal")}.
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-(Sepal.Width:Petal.Length)}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{extract_column_names(iris, select = c("Species", "Test"))}
will just return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{append}{Logical or string. If \code{TRUE}, standardized variables get new
column names (with the suffix \code{"_z"}) and are appended (column bind) to \code{x},
thus returning both the original and the standardized variables. If \code{FALSE},
original variables in \code{x} will be overwritten by their standardized versions.
If a character value, standardized variables are appended with new column
names (using the defined suffix) to the original data frame.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{regex}{Logical, if \code{TRUE}, the search pattern from \code{select} will be
treated as regular expression. When \code{regex = TRUE}, select \emph{must} be a
character string (or a variable containing a character string) and is not
allowed to be one of the supported select-helpers or a character vector
of length > 1. \code{regex = TRUE} is comparable to using one of the two
select-helpers, \code{select = contains("")} or \code{select = regex("")}, however,
since the select-helpers may not work when called from inside other
functions (see 'Details'), this argument may be used as workaround.}
}
\value{
A normalized object.
}
\description{
Performs a normalization of data, i.e., it scales variables in the range
0 - 1. This is a special case of \code{\link[=rescale]{rescale()}}. \code{unnormalize()} is the
counterpart, but only works for variables that have been normalized with
\code{normalize()}.
}
\details{
\itemize{
\item If \code{x} is a matrix, normalization is performed across all values (not
column- or row-wise). For column-wise normalization, convert the matrix to a
data.frame.
\item If \code{x} is a grouped data frame (\code{grouped_df}), normalization is performed
separately for each group.
}
}
\section{Selection of variables - the \code{select} argument}{

For most functions that have a \code{select} argument (including this function),
the complete input data frame is returned, even when \code{select} only selects
a range of variables. That is, the function is only applied to those variables
that have a match in \code{select}, while all other variables remain unchanged.
In other words: for this function, \code{select} will not omit any non-included
variables, so that the returned data frame will include all variables
from the input data frame.
}

\examples{

normalize(c(0, 1, 5, -5, -2))
normalize(c(0, 1, 5, -5, -2), include_bounds = FALSE)
# use a value defining the bounds
normalize(c(0, 1, 5, -5, -2), include_bounds = .001)

head(normalize(trees))

}
\references{
Smithson M, Verkuilen J (2006). A Better Lemon Squeezer? Maximum-Likelihood
Regression with Beta-Distributed Dependent Variables. Psychological Methods,
11(1), 54–71.
}
\seealso{
See \code{\link[=makepredictcall.dw_transformer]{makepredictcall.dw_transformer()}} for use in model formulas.

Other transform utilities: 
\code{\link{ranktransform}()},
\code{\link{rescale}()},
\code{\link{reverse}()},
\code{\link{standardize}()}
}
\concept{transform utilities}
