% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd_args.R
\name{cmd_list_interp}
\alias{cmd_list_interp}
\title{Convert list of function arguments to list of command flags}
\usage{
cmd_list_interp(args, flag_lookup = NULL)
}
\arguments{
\item{args}{named list output from get*Args family of functions.}

\item{flag_lookup}{optional named vector used to convert args to command flags}
}
\value{
named list
}
\description{
Function also handles error checking to ensure args contain valid data types,
and looks for common usage mistakes.
}
\details{
The list structure is more amenable to manipulation by package developers for
advanced use before evaluating them to the command flags vector with
cmd_list_to_flags().
}
\examples{
theFunction <- function(...){cmd_args_all()}
theArgs <- theFunction(arg1 = "value", arg2 = TRUE)
flagList <- cmd_list_interp(theArgs)
flags <- cmd_list_to_flags(flagList)
}
