% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixt.R
\name{posixt-shifting}
\alias{posixt-shifting}
\alias{date_shift.POSIXt}
\title{Shifting: date and date-time}
\usage{
\method{date_shift}{POSIXt}(
  x,
  target,
  ...,
  which = "next",
  boundary = "keep",
  nonexistent = NULL,
  ambiguous = x
)
}
\arguments{
\item{x}{\verb{[POSIXct / POSIXlt]}

A date-time vector.}

\item{target}{\verb{[weekday]}

A weekday created from \code{\link[=weekday]{weekday()}} to target.

Generally this is length 1, but can also be the same length as \code{x}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{which}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"next"}: Shift to the next instance of the \code{target} weekday.
\item \verb{"previous}: Shift to the previous instance of the \code{target} weekday.
}}

\item{boundary}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"keep"}: If \code{x} is currently on the \code{target} weekday, return it.
\item \code{"advance"}: If \code{x} is currently on the \code{target} weekday, advance it
anyways.
}}

\item{nonexistent}{\verb{[character / NULL]}

One of the following nonexistent time resolution strategies, allowed to be
either length 1, or the same length as the input:
\itemize{
\item \code{"roll-forward"}: The next valid instant in time.
\item \code{"roll-backward"}: The previous valid instant in time.
\item \code{"shift-forward"}: Shift the nonexistent time forward by the size of
the daylight saving time gap.
\item \verb{"shift-backward}: Shift the nonexistent time backward by the size of
the daylight saving time gap.
\item \code{"NA"}: Replace nonexistent times with \code{NA}.
\item \code{"error"}: Error on nonexistent times.
}

Using either \code{"roll-forward"} or \code{"roll-backward"} is generally
recommended over shifting, as these two strategies maintain the
\emph{relative ordering} between elements of the input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{nonexistent} must be supplied
and cannot be \code{NULL}. This is a convenient way to make production code
robust to nonexistent times.}

\item{ambiguous}{\verb{[character / zoned_time / POSIXct / list(2) / NULL]}

One of the following ambiguous time resolution strategies, allowed to be
either length 1, or the same length as the input:
\itemize{
\item \code{"earliest"}: Of the two possible times, choose the earliest one.
\item \code{"latest"}: Of the two possible times, choose the latest one.
\item \code{"NA"}: Replace ambiguous times with \code{NA}.
\item \code{"error"}: Error on ambiguous times.
}

Alternatively, \code{ambiguous} is allowed to be a zoned_time (or POSIXct) that
is either length 1, or the same length as the input. If an ambiguous time
is encountered, the zoned_time is consulted. If the zoned_time corresponds
to a naive_time that is also ambiguous \emph{and} uses the same daylight saving
time transition point as the original ambiguous time, then the offset of
the zoned_time is used to resolve the ambiguity. If the ambiguity cannot be
resolved by consulting the zoned_time, then this method falls back to
\code{NULL}.

Finally, \code{ambiguous} is allowed to be a list of size 2, where the first
element of the list is a zoned_time (as described above), and the second
element of the list is an ambiguous time resolution strategy to use when
the ambiguous time cannot be resolved by consulting the zoned_time.
Specifying a zoned_time on its own is identical to \verb{list(<zoned_time>, NULL)}.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{ambiguous} must be supplied and
cannot be \code{NULL}. Additionally, \code{ambiguous} cannot be specified as a
zoned_time on its own, as this implies \code{NULL} for ambiguous times that the
zoned_time cannot resolve. Instead, it must be specified as a list
alongside an ambiguous time resolution strategy as described above. This is
a convenient way to make production code robust to ambiguous times.}
}
\value{
\code{x} shifted to the \code{target} weekday.
}
\description{
\code{date_shift()} shifts \code{x} to the \code{target} weekday. You can shift to the next
or previous weekday. If \code{x} is currently on the \code{target} weekday, you can
choose to leave it alone or advance it to the next instance of the \code{target}.

Shifting with date-times retains the time of day where possible. Be aware
that you can run into daylight saving time issues if you shift into a
daylight saving time gap or fallback period.
}
\examples{
tuesday <- weekday(clock_weekdays$tuesday)

x <- as.POSIXct("1970-04-22 02:30:00", "America/New_York")

# Shift to the next Tuesday
date_shift(x, tuesday)

# Be aware that you can run into daylight saving time issues!
# Here we shift directly into a daylight saving time gap
# from 01:59:59 -> 03:00:00
sunday <- weekday(clock_weekdays$sunday)
try(date_shift(x, sunday))

# You can resolve this with the `nonexistent` argument
date_shift(x, sunday, nonexistent = "roll-forward")
}
