% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R, R/generics.R
\name{as.bitwhich.NULL}
\alias{as.bitwhich.NULL}
\alias{as.bitwhich.bitwhich}
\alias{as.bitwhich.which}
\alias{as.bitwhich.ri}
\alias{as.bitwhich.integer}
\alias{as.bitwhich.double}
\alias{as.bitwhich.logical}
\alias{as.bitwhich.bit}
\alias{as.bitwhich}
\title{Coercing to bitwhich}
\usage{
\method{as.bitwhich}{`NULL`}(x, ...)

\method{as.bitwhich}{bitwhich}(x, ...)

\method{as.bitwhich}{which}(x, maxindex = attr(x, "maxindex"), ...)

\method{as.bitwhich}{ri}(x, ...)

\method{as.bitwhich}{integer}(x, poslength = NULL, ...)

\method{as.bitwhich}{double}(x, poslength = NULL, ...)

\method{as.bitwhich}{logical}(x, poslength = NULL, ...)

\method{as.bitwhich}{bit}(x, range = NULL, poslength = NULL, ...)

as.bitwhich(x = NULL, ...)
}
\arguments{
\item{x}{An object of class 'bitwhich', 'integer', 'logical' or 'bit' or an
integer vector as resulting from 'which'}

\item{\dots}{further arguments}

\item{maxindex}{the length of the new bitwhich vector}

\item{poslength}{the number of selected elements}

\item{range}{a \code{\link{ri}} or an integer vector of length==2 giving a
range restriction for chunked processing}
}
\value{
a value of class \code{\link{bitwhich}}
}
\description{
Functions to coerce to bitwhich
}
\section{Methods (by class)}{
\itemize{
\item \code{NULL}: method to coerce to \code{\link{bitwhich}} (zero length) from \code{\link{NULL}}

\item \code{bitwhich}: method to coerce to \code{\link{bitwhich}} from \code{\link{bitwhich}}

\item \code{which}: method to coerce to \code{\link{bitwhich}} from \code{\link[=as.which]{which}}

\item \code{ri}: method to coerce to \code{\link{bitwhich}} from \code{\link{ri}}

\item \code{integer}: method to coerce to \code{\link{bitwhich}} from
\code{\link{integer}} (\code{0} and \code{NA} become \code{FALSE}, everthing
else becomes \code{TRUE})

\item \code{double}: method to coerce to \code{\link{bitwhich}} from
\code{\link{double}} (\code{0} and \code{NA} become \code{FALSE}, everthing
else becomes \code{TRUE})

\item \code{logical}: method to coerce to \code{\link{bitwhich}} from \code{\link{logical}}

\item \code{bit}: method to coerce to \code{\link{bitwhich}} from \code{\link{bit}}
}}

\examples{
as.bitwhich(c(0L,1L,2L,-2L,NA))
as.bitwhich(c(0,1,2,-2,NA))

 as.bitwhich(c(NA,NA,NA))
 as.bitwhich(c(FALSE, FALSE, FALSE))
 as.bitwhich(c(FALSE, FALSE, TRUE))
 as.bitwhich(c(FALSE, TRUE, TRUE))
 as.bitwhich(c(TRUE, TRUE, TRUE))

}
\seealso{
\code{\link{CoercionToStandard}}, \code{\link{as.booltype}}, \code{\link{as.bit}}, \code{\link{as.bitwhich}}
, \code{\link{as.which}}, \code{\link{as.ri}}, \code{\link[ff]{as.hi}},  \code{\link[ff]{as.ff}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
