% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dont_stop}
\alias{dont_stop}
\title{Run code without stopping}
\usage{
dont_stop(expr)
}
\arguments{
\item{expr}{Code to execute.}
}
\value{
A list containing the results of evaluating each call in \code{expr}.
}
\description{
Runs code without stopping for warnings or errors.
}
\note{
This function is dangerous, since it overrides warnings and errors.
Its intended use is for documenting examples of warnings and errors.
}
\examples{
dont_stop({
  warning("a warning")
  x <- 1
  stop("an error")
  y <- sqrt(exp(x + 1))
  assert_is_identical_to_true(y)
  y > 0
})
}
\seealso{
\code{\link[base]{warning}} and \code{\link[base]{stop}} for 
generating warnings and errors respectively; \code{\link[base]{try}} and
\code{\link[base]{conditions}} for handling them.
}
