% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colAlls,xgCMatrix-method}
\alias{colAlls,xgCMatrix-method}
\alias{rowAlls,xgCMatrix-method}
\title{Check if all elements in a row (column) of a matrix-like object are equal to
a value}
\usage{
\S4method{colAlls}{xgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  useNames = NA
)

\S4method{rowAlls}{xgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  value = TRUE,
  na.rm = FALSE,
  useNames = NA
)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{value}{The value to search for.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{logical}} \code{\link{vector}} of length N (K).
}
\description{
Check if all elements in a row (column) of a matrix-like object are equal to
a value.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowAlls}} /
\code{matrixStats::\link[matrixStats]{colAlls}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowAlls(mat)
colAlls(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowAlls]{rowAlls}()} and
\code{matrixStats::\link[matrixStats:rowAlls]{colAlls}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if \emph{any} element is equal to a value, see
\code{\link[MatrixGenerics]{rowAnys}()}.
\item \code{base::\link{all}()}.
}
}
