% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5L.R
\name{H5Ldelete}
\alias{H5Ldelete}
\title{Remove a link from a group}
\usage{
H5Ldelete(h5loc, name)
}
\arguments{
\item{h5loc}{An object of class \linkS4class{H5IdComponent} representing a H5
location identifier (file or group).}

\item{name}{The name of the link to be deleted.}
}
\description{
Remove a link from a group
}
\examples{

h5file <- tempfile(pattern = "_ex_H5L.h5")

# create an hdf5 file and a group
h5createFile( h5file )
h5createGroup(h5file,"/foo")

# reopen file and confirm "/foo" exists but "/baa" does not
fid <- H5Fopen(h5file)
H5Lexists(fid, "/foo")

# remove the link to "/foo" and confirm it no longer exists
H5Ldelete(fid, "/foo")
H5Lexists(fid, "/foo")

H5Fclose(fid)

}
