test_that("`extractPCMBLOSUM()` works", {
    x = paste0(
        'MDAMKRGLCCVLLLCGAVFVSPSQEIHARFRRGARSYQVICRDEKTQMIYQQHQSWLRP',
        'VLRSNRVEYCWCNSGRAQCHSVPVKSCSEPRCFNGGTCQQALYFSDFVCQCPEGFAGKCC',
        'EIDTRATCYEDQGISYRGTWSTAESGAECTNWNSSALAQKPYSGRRPDAIRLGLGNHNYC',
        'RNPDRDSKPWCYVFKAGKYSSEFCSTPACSEGNSDCYFGNGSAYRGTHSLTESGASCLPW',
        'NSMILIGKVYTAQNPSAQALGLGKHNYCRNPDGDAKPWCHVLKNRRLTWEYCDVPSCSTC',
        'GLRQYSQPQFRIKGGLFADIASHPWQAAIFAKHRRSPGERFLCGGILISSCWILSAAHCF',
        'QERFPPHHLTVILGRTYRVVPGEEEQKFEVEKYIVHKEFDDDTYDNDIALLQLKSDSSRC',
        'AQESSVVRTVCLPPADLQLPDWTECELSGYGKHEALSPFYSERLKEAHVRLYPSSRCTSQ',
        'HLLNRTVTDNMLCAGDTRSGGPQANLHDACQGDSGGPLVCLNDGRMTLVGIISWGLGCGQ',
        'KDVPGVYTKVTNYLDWIRDNMRP'
    )
    blosum = extractPCMBLOSUM(
        x, submat = 'AABLOSUM62', k = 5, lag = 7,
        scale = TRUE, silent = TRUE
    )
    pam = extractPCMBLOSUM(
        x, submat = 'AAPAM250', k = 3, lag = 9,
        scale = TRUE, silent = TRUE
    )

    expect_equal(length(blosum), 175L)
    expect_equal(length(pam), 81L)
})
