% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowAnys.R
\name{rowAnys}
\alias{rowAnys}
\alias{rowAnys,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowAnys,ANY-method}
\alias{colAnys}
\alias{colAnys,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colAnys,ANY-method}
\title{Check if any elements in a row (column) of a matrix-like object is equal to
a value}
\usage{
rowAnys(x, rows = NULL, cols = NULL, value = TRUE, na.rm = FALSE, ...,
  useNames = NA)

\S4method{rowAnys}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, value = TRUE, na.rm = FALSE, dim. = dim(x), ...,
  useNames = NA)

\S4method{rowAnys}{ANY}(x, rows = NULL, cols = NULL, value = TRUE,
  na.rm = FALSE, ..., useNames = NA)

colAnys(x, rows = NULL, cols = NULL, value = TRUE, na.rm = FALSE, ...,
  useNames = NA)

\S4method{colAnys}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, value = TRUE, na.rm = FALSE, dim. = dim(x), ...,
  useNames = NA)

\S4method{colAnys}{ANY}(x, rows = NULL, cols = NULL, value = TRUE,
  na.rm = FALSE, ..., useNames = NA)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{value}{The value to search for.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{logical}} \code{\link{vector}} of length N (K).
}
\description{
Check if any elements in a row (column) of a matrix-like object is equal to
a value.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowAnys}} /
\code{matrixStats::\link[matrixStats]{colAnys}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowAnys(mat)
colAnys(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowAlls]{rowAnys}()} and
\code{matrixStats::\link[matrixStats:rowAlls]{colAnys}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For checks if \emph{all} elements are equal to a value, see
\code{\link{rowAlls}()}.
\item \code{base::\link{any}()}.
}
}
