% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_layout.R
\name{layoutPlot}
\alias{layoutPlot}
\title{Create layout plot of flowcell}
\usage{
layoutPlot(summaryData, attribute = NULL)
}
\arguments{
\item{summaryData}{Object of class \linkS4class{Fast5Summary}.}

\item{attribute}{Character string indicating what to plot. Currently accepted values are: "nreads", "kb", "signal".}
}
\value{
Returns an object of \code{gg} representing the plot.
}
\description{
Creates a plot representing the layout of a MinION flow cell.  Each circle represents an idividual channel with the intensity relecting the total kilobases of sequence produced.  This only considers reads marked as template or complement, 2D reads are ignored as they are generated from the former two.
}
\examples{
if( require(minionSummaryData) ) {
   data(s.typhi.rep2, package = 'minionSummaryData')
   layoutPlot( s.typhi.rep2, attribute = 'nreads' )
   layoutPlot( s.typhi.rep2, attribute = 'kb' )
}
}
