% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighlightTrack-class.R
\docType{class}
\name{HighlightTrack-class}
\alias{HighlightTrack-class}
\alias{initialize,HighlightTrack-method}
\alias{HighlightTrack}
\alias{displayPars<-,HighlightTrack,list-method}
\alias{length,HighlightTrack-method}
\alias{chromosome<-,HighlightTrack-method}
\alias{setStacks,HighlightTrack-method}
\alias{consolidateTrack,HighlightTrack-method}
\alias{subset,HighlightTrack-method}
\alias{show,HighlightTrack-method}
\title{HighlightTrack class and methods}
\usage{
\S4method{initialize}{HighlightTrack}(.Object, trackList, ...)

HighlightTrack(
  trackList = list(),
  range = NULL,
  start = NULL,
  end = NULL,
  width = NULL,
  chromosome,
  genome,
  name = "HighlightTrack",
  ...
)

\S4method{displayPars}{HighlightTrack,list}(x, recursive = FALSE) <- value

\S4method{length}{HighlightTrack}(x)

\S4method{chromosome}{HighlightTrack}(GdObject) <- value

\S4method{setStacks}{HighlightTrack}(GdObject, ...)

\S4method{consolidateTrack}{HighlightTrack}(GdObject, chromosome, ...)

\S4method{subset}{HighlightTrack}(x, ...)

\S4method{show}{HighlightTrack}(object)
}
\arguments{
\item{.Object}{.Object}

\item{trackList}{A list of Gviz track objects that all have to inherit from
class \code{GdObject}.}

\item{\dots}{All additional parameters are ignored.}

\item{range}{An optional meta argument to handle the different input types. If the
\code{range} argument is missing, all the relevant information to create the
object has to be provided as individual function arguments (see below).

The different input options for \code{range} are:

\describe{

\item{}{A \code{GRanges} object: the genomic ranges for the highlighting
regions.}

\item{}{An \code{\linkS4class{IRanges}} object: almost identical to the
\code{GRanges} case, except that the chromosome information has to be
provided in the separate \code{chromosome} argument, because it can not be
directly encoded in an \code{IRanges} object.}

\item{}{A \code{data.frame} object: the \code{data.frame} needs to contain
at least the two mandatory columns \code{start} and \code{end} with the
range coordinates. It may also contain a \code{chromosome} column with the
chromosome information for each range. If missing, this information will be
drawn from the constructor's \code{chromosome} argument.}

}}

\item{start, end}{An integer scalar with the genomic start or end coordinates
for the highlighting range. Can also be supplied as part of the \code{range}
argument.}

\item{width}{An integer vector of widths for highlighting ranges. This can
be used instead of either \code{start} or \code{end} to specify the range
coordinates.}

\item{chromosome}{The chromosome on which the track's genomic ranges are
defined. A valid UCSC chromosome identifier if
\code{options(ucscChromosomeNames=TRUE)}. Please note that in this case only
syntactic checking takes place, i.e., the argument value needs to be an
integer, numeric character or a character of the form \code{chrx}, where
\code{x} may be any possible string. The user has to make sure that the
respective chromosome is indeed defined for the the track's genome. If not
provided here, the constructor will try to build the chromosome information
based on the available inputs, and as a last resort will fall back to the
value \code{chrNA}. Please note that by definition all objects in the
\code{Gviz} package can only have a single active chromosome at a time
(although internally the information for more than one chromosome may be
present), and the user has to call the \code{chromosome<-} replacement
method in order to change to a different active chromosome.}

\item{genome}{The genome on which the track's ranges are defined. Usually
this is a valid UCSC genome identifier, however this is not being formally
checked at this point. If not provided here the constructor will try to
extract this information from the provided inputs, and eventually will fall
back to the default value of \code{NA}.}

\item{name}{Character scalar of the track's name. This is not really used
and only exists fro completeness.}

\item{x}{A valid track object class name, or the object itself, in which
case the class is derived directly from it.}

\item{recursive}{\code{logical}}

\item{value}{Value to be set.}

\item{GdObject}{Object of \code{GdObject-class}.}

\item{object}{object}
}
\value{
The return value of the constructor function is a new object of class
\code{HighlightTrack}.
}
\description{
A container for other track objects from the Gviz package that allows for
the addition of a common highlighting area across tracks.
}
\details{
A track to conceptionally group other Gviz track objects into a meta track
for the sole purpose of overlaying all the contained tracks with the same
highlighting region as defined by the objects genomic ranges. During
rendering the contained tracks will be treated as if they had been provided
to the \code{plotTracks} function as individual objects.
}
\section{Functions}{
\itemize{
\item \code{initialize,HighlightTrack-method}: Initialize.

\item \code{HighlightTrack}: Constructor function for
\code{HighlightTrack-class}.

\item \code{displayPars<-,HighlightTrack,list-method}: set display parameters using the values of
the named list in value. See \code{\link{settings}} for details on display
parameters and customization.

\item \code{length,HighlightTrack-method}: return the number of subtracks.

\item \code{chromosome<-,HighlightTrack-method}: replace the value of the track's chromosome.
This has to be a valid UCSC chromosome identifier or an integer or character
scalar that can be reasonably coerced into one.

\item \code{setStacks,HighlightTrack-method}: Rrecompute the stacks based on the available
space and on the object's track items and stacking settings.
This really just calls the \code{setStacks} methods for the contained tracks and
only exists for dispatching reasons.

\item \code{consolidateTrack,HighlightTrack-method}: Consolidate
For a \code{HighlightTrack} apply the method on each of the subtracks in
the \code{trackList} slot

\item \code{subset,HighlightTrack-method}: subset all the contained tracks in an HighlightTrack by coordinates and sort if necessary.

\item \code{show,HighlightTrack-method}: Show method.
}}

\section{Objects from the Class}{


Objects can be created using the constructor function \code{HighlightTrack}.
}

\examples{
## Object construction:
set.seed(123)
dat <- runif(100, min = -2, max = 22)
gt <- GenomeAxisTrack()
dt <- DataTrack(data = dat, start = sort(sample(200, 100)), width = 1, genome = "hg19")

ht <- HighlightTrack(trackList = list(gt, dt))
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
