// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_FEED_INTERNALS_FEED_INTERNALS_UI_H_
#define CHROME_BROWSER_UI_WEBUI_FEED_INTERNALS_FEED_INTERNALS_UI_H_

#include <memory>

#include "base/macros.h"
#include "chrome/browser/ui/webui/feed_internals/feed_internals.mojom-forward.h"
#include "chrome/browser/ui/webui/feed_internals/feed_internals_page_handler.h"
#include "components/feed/buildflags.h"
#include "mojo/public/cpp/bindings/pending_receiver.h"
#include "ui/webui/mojo_web_ui_controller.h"

class Profile;
class FeedV2InternalsPageHandler;

// During the interim migration to Feed, this page will be co-located with
// snippets-internals. Once migration is complete, and snippets-internals is
// removed, this page will be moved to chrome://feed-internals.

// UI controller for the Feed internals page, hooks up a concrete implementation
// of feed_internals::mojom::PageHandler to requests for that page handler
// that will come from the frontend.
class FeedInternalsUI : public ui::MojoWebUIController {
 public:
  explicit FeedInternalsUI(content::WebUI* web_ui);
  ~FeedInternalsUI() override;

  // Instantiates the implementor of the feed_internals::mojom::PageHandler mojo
  // interface passing the pending receiver that will be internally bound.
  void BindInterface(
      mojo::PendingReceiver<feed_internals::mojom::PageHandler> receiver);

 private:
  Profile* profile_;
#if BUILDFLAG(ENABLE_FEED_V1)
  std::unique_ptr<FeedInternalsPageHandler> page_handler_;
#endif
#if BUILDFLAG(ENABLE_FEED_V2)
  std::unique_ptr<FeedV2InternalsPageHandler> v2_page_handler_;
#endif
  WEB_UI_CONTROLLER_TYPE_DECL();

  DISALLOW_COPY_AND_ASSIGN(FeedInternalsUI);
};

#endif  // CHROME_BROWSER_UI_WEBUI_FEED_INTERNALS_FEED_INTERNALS_UI_H_
