#!/bin/bash

set -e
set -u

testdir=$PWD/tests
cp -R $testdir $AUTOPKGTEST_TMP
cd $AUTOPKGTEST_TMP

for py3ver in $(py3versions -vs)
do
    echo "Running main upstream test set with Python ${py3ver}."
    echo "TODO: Whitelist the sampler tests that don't require unsatisfied deps."
    echo "TODO: Whitelist the importance tests that don't require unsatisfied deps."
    /usr/bin/python${py3ver} -B -m pytest -v                    \
                   --ignore=tests/visualization_tests/          \
                   --ignore=tests/samplers_tests/               \
                   --ignore=tests/importance_tests/             \
                   --ignore=tests/terminator_tests/             \
                   --ignore=tests/artifacts_tests/              \
		   --ignore=tests/gp_tests/test_acqf.py         \
                   tests/
done
