# Changelog

All notable changes to this project will be documented in this file.

## [22.4.1] - 2023-01-09

## Added
* documentation for NASL cert-functions (#1272) [c32044e3](https://github.com/greenbone/openvas-scanner/commit/c32044e3)
* documentation for NASL snmp-functions (#1270) [d7168b5f](https://github.com/greenbone/openvas-scanner/commit/d7168b5f)
* document Networking function in the NASL manual (#1256) [395b3a8f](https://github.com/greenbone/openvas-scanner/commit/395b3a8f)
* documentation for NASL host-functions (#1264) [934f70da](https://github.com/greenbone/openvas-scanner/commit/934f70da)
* documentation for built-in nasl HTTP Functions [32ca0d99](https://github.com/greenbone/openvas-scanner/commit/32ca0d99)
* NASL documentation for unsafe functions [8ca6e91f](https://github.com/greenbone/openvas-scanner/commit/8ca6e91f)
* documentation for NASL ssh-functions [40276ede](https://github.com/greenbone/openvas-scanner/commit/40276ede)
* Initial rust NASL interpreter (#1234) [d5e9f103](https://github.com/greenbone/openvas-scanner/commit/d5e9f103)
* documentation [4828d140](https://github.com/greenbone/openvas-scanner/commit/4828d140)
* more documentation [4a93a372](https://github.com/greenbone/openvas-scanner/commit/4a93a372)
* more documentation [1965054b](https://github.com/greenbone/openvas-scanner/commit/1965054b)
* more documentation [36e1afc4](https://github.com/greenbone/openvas-scanner/commit/36e1afc4)
* documentation for nasl functions [ee2084eb](https://github.com/greenbone/openvas-scanner/commit/ee2084eb)
* convertion from string timestamp to second since epoch for cration_time and last_modification tags [5adeb7fe](https://github.com/greenbone/openvas-scanner/commit/5adeb7fe)
* handle wrong plugin path error [14a7ca0d](https://github.com/greenbone/openvas-scanner/commit/14a7ca0d)
* Implement Display trait for Category This allows to convert the category directly to a string. [263411f5](https://github.com/greenbone/openvas-scanner/commit/263411f5)
* Document which Nvt members and methods are used during the plugin upload [2a692598](https://github.com/greenbone/openvas-scanner/commit/2a692598)
* store references in the redis cache. [2affab75](https://github.com/greenbone/openvas-scanner/commit/2affab75)
* function get_prefs() to get the a vector of string representing the script preferences, as they have to be stored in the redis cache [93a70b17](https://github.com/greenbone/openvas-scanner/commit/93a70b17)
* get the references from the nvt structure and store it in the redis cache [1e8b375b](https://github.com/greenbone/openvas-scanner/commit/1e8b375b)
* function get_refs() [2b822a08](https://github.com/greenbone/openvas-scanner/commit/2b822a08)
* function for returning NvtRef members [ef20279c](https://github.com/greenbone/openvas-scanner/commit/ef20279c)
* test for add_nvt [172a1697](https://github.com/greenbone/openvas-scanner/commit/172a1697)
* function redis_add_nvt() to add a new nvt to the current redis namespace [a22b44e5](https://github.com/greenbone/openvas-scanner/commit/a22b44e5)
* functions to add preferences, references and severities to the Nvt structure [8e3b570d](https://github.com/greenbone/openvas-scanner/commit/8e3b570d)
* Default trait for Nvt. Also fix the new() to retunr the initialized Nvt. Adjust format. [38936941](https://github.com/greenbone/openvas-scanner/commit/38936941)
* function add_tag() [89803411](https://github.com/greenbone/openvas-scanner/commit/89803411)
* and change documentation [cdfc94ae](https://github.com/greenbone/openvas-scanner/commit/cdfc94ae)
* RedisValueHandler to handle the different value types in a Redis Result. It was added first for handling Nil, e.g. when a key is not found. [6f9d9321](https://github.com/greenbone/openvas-scanner/commit/6f9d9321)
* Function for set and get the nvtcache key. This should contain the feed version Also a function for resetting the nvtcache (delete and release). [b8595215](https://github.com/greenbone/openvas-scanner/commit/b8595215)
* wrap function for setting keys with generic values. This is done for making the RedisCtx::kb member private. so is not accesible from outside the module. [921124e3](https://github.com/greenbone/openvas-scanner/commit/921124e3)
* Tooling for documentation manual and NASL man (#1194) [5478e0d6](https://github.com/greenbone/openvas-scanner/commit/5478e0d6)
* |, && to nasl-syntax-parser [b84419a5](https://github.com/greenbone/openvas-scanner/commit/b84419a5)
* !, != and !~ operations into nasl-syntax-parser [4e4d61d4](https://github.com/greenbone/openvas-scanner/commit/4e4d61d4)
* - handling [60117599](https://github.com/greenbone/openvas-scanner/commit/60117599)
* missing scanneraux.c file, which includes de destroy_scan_globals() [ab20dab3](https://github.com/greenbone/openvas-scanner/commit/ab20dab3)
* document two new scanner preferences for alive tests (#1204) [9a05f630](https://github.com/greenbone/openvas-scanner/commit/9a05f630)
* documentation for LSC IPC data type [0c8c8c3d](https://github.com/greenbone/openvas-scanner/commit/0c8c8c3d)
* documentation for IPC protocol [db8cff22](https://github.com/greenbone/openvas-scanner/commit/db8cff22)
* inter process communication [e3716515](https://github.com/greenbone/openvas-scanner/commit/e3716515)
* fork observing mechanism (#1165) [c72b6df5](https://github.com/greenbone/openvas-scanner/commit/c72b6df5)

## Removed
* unnecessary  mut [5608984c](https://github.com/greenbone/openvas-scanner/commit/5608984c)
* nvt::destroy(). Not necessary [26d2287c](https://github.com/greenbone/openvas-scanner/commit/26d2287c)
* Remove unnecessary sleep used for debugging (#1219) [931f757f](https://github.com/greenbone/openvas-scanner/commit/931f757f)
* unnecessary code in libs CMakeLists.txt files (#1156) [b614dbd6](https://github.com/greenbone/openvas-scanner/commit/b614dbd6)
* script_bugtraq_id completely (#1124) [8f1dfff4](https://github.com/greenbone/openvas-scanner/commit/8f1dfff4)

## Changed
* Use action for release Workflow [fbd51e7b](https://github.com/greenbone/openvas-scanner/commit/fbd51e7b)
* Update creating tags for container images (#1263) [31791b5a](https://github.com/greenbone/openvas-scanner/commit/31791b5a)
* Use redis pipeline for writing a batch of commands at once [23adeef0](https://github.com/greenbone/openvas-scanner/commit/23adeef0)
* check if there are preferences before add them [95ee9d40](https://github.com/greenbone/openvas-scanner/commit/95ee9d40)
* Split the function add_nvt. Now the duplicated oid check is performed in a private function [5a1b30cb](https://github.com/greenbone/openvas-scanner/commit/5a1b30cb)
* Get the key string as reference, so it is not consumed [35d3d117](https://github.com/greenbone/openvas-scanner/commit/35d3d117)
* use globally stored main_kb instead of passing it around [faf8fe57](https://github.com/greenbone/openvas-scanner/commit/faf8fe57)
* typo [9c7faec5](https://github.com/greenbone/openvas-scanner/commit/9c7faec5)
* rename kb_check*() functions to kb_item_*_with_main_kb_check. [641f2b84](https://github.com/greenbone/openvas-scanner/commit/641f2b84)
* Improve integration test [5cfcac38](https://github.com/greenbone/openvas-scanner/commit/5cfcac38)
* set_oid() funtion doesn't need to return anything [352bcbae](https://github.com/greenbone/openvas-scanner/commit/352bcbae)
* make the tag member in the Nvt structure a Vector of (key,val) tuples. [260ccb18](https://github.com/greenbone/openvas-scanner/commit/260ccb18)
* Split the strings and use vector of strings instead where necessary [6dd0a8e0](https://github.com/greenbone/openvas-scanner/commit/6dd0a8e0)
* better error handling. Embeed the RedisError instead of wrapping it. Also defined more DbError types. [18aaf2a4](https://github.com/greenbone/openvas-scanner/commit/18aaf2a4)
* Improve display implementation for Catefory [dc7040dd](https://github.com/greenbone/openvas-scanner/commit/dc7040dd)
* Use Vec instead of LinkedList for refs, prefs and severities [db988443](https://github.com/greenbone/openvas-scanner/commit/db988443)
* Don't return Results for nvt::set_*() functions.  Don't return a Result, but a &str from nvt::get_*() functions [33dc3540](https://github.com/greenbone/openvas-scanner/commit/33dc3540)
* dont use constants. Use environment variables instead, with default fallback, instead [b8ba2baf](https://github.com/greenbone/openvas-scanner/commit/b8ba2baf)
* small code improvemente [3a98b57d](https://github.com/greenbone/openvas-scanner/commit/3a98b57d)
* use the right redis cmd, to add the fields in the right order [34ea4422](https://github.com/greenbone/openvas-scanner/commit/34ea4422)
* Use the globally defined variable NVTICACHE [e8ba4477](https://github.com/greenbone/openvas-scanner/commit/e8ba4477)
* fix nvtcache::add_nvt() [26f065c3](https://github.com/greenbone/openvas-scanner/commit/26f065c3)
* get functions. Return a clone of the Nvt members O Otherwise, the Nvt struct was borrowed here and it can't be borrowed again later. [0f0c12be](https://github.com/greenbone/openvas-scanner/commit/0f0c12be)
* make structs publics. [efa3d30c](https://github.com/greenbone/openvas-scanner/commit/efa3d30c)
* abort on found db inconsistency [96a3daec](https://github.com/greenbone/openvas-scanner/commit/96a3daec)
* add quoteable string to Tokenizer [501f558f](https://github.com/greenbone/openvas-scanner/commit/501f558f)
* add unquoteable string to tokenizer [4caee914](https://github.com/greenbone/openvas-scanner/commit/4caee914)
* add tokenizing of triple and four character tokens [94d9631e](https://github.com/greenbone/openvas-scanner/commit/94d9631e)
* add more double tokens into Tokenizer [82a8a51d](https://github.com/greenbone/openvas-scanner/commit/82a8a51d)
* switch build_token to macro, create macro to build double_tokens [a9fe6ea6](https://github.com/greenbone/openvas-scanner/commit/a9fe6ea6)
* add tokenizer for single character tokens [cf380783](https://github.com/greenbone/openvas-scanner/commit/cf380783)
* rename bump to advance [d8053f29](https://github.com/greenbone/openvas-scanner/commit/d8053f29)
* crsr to cursor to be more readable [5a2b79a3](https://github.com/greenbone/openvas-scanner/commit/5a2b79a3)
* add cursor to move char wise within source code [f77185fa](https://github.com/greenbone/openvas-scanner/commit/f77185fa)
* Apply suggested changes [bf8c1bf9](https://github.com/greenbone/openvas-scanner/commit/bf8c1bf9)
* make error message clearer when chdir fails [e29c588c](https://github.com/greenbone/openvas-scanner/commit/e29c588c)
* Split creating build and production images [b5bfee64](https://github.com/greenbone/openvas-scanner/commit/b5bfee64)
* Build container images for pull requests too [54da5972](https://github.com/greenbone/openvas-scanner/commit/54da5972)
* Use docker/meta-action for container tags and labels [3c086d2b](https://github.com/greenbone/openvas-scanner/commit/3c086d2b)
* Use return instead of exit in openvas.c (#1155) [3ac3f51f](https://github.com/greenbone/openvas-scanner/commit/3ac3f51f)
* more useful logging for socket_negotiate_ssl (#1132) [149ccc21](https://github.com/greenbone/openvas-scanner/commit/149ccc21)

## Bug Fixes
* Stop scan (#1252) [e9167809](https://github.com/greenbone/openvas-scanner/commit/e9167809)
* logic. Now the UA will be saved. [dbb492be](https://github.com/greenbone/openvas-scanner/commit/dbb492be)
* parse every json string in the IPC pipe. [8b2f5878](https://github.com/greenbone/openvas-scanner/commit/8b2f5878)
* set the main kb during init openvas-nasl. [25d2a3aa](https://github.com/greenbone/openvas-scanner/commit/25d2a3aa)
* initialize ipc data structure (#1245) [cf2f0679](https://github.com/greenbone/openvas-scanner/commit/cf2f0679)
* test [12f40433](https://github.com/greenbone/openvas-scanner/commit/12f40433)
* Reset main kb link after fork()'ing [2fa8ea8d](https://github.com/greenbone/openvas-scanner/commit/2fa8ea8d)
* plugin upload when signature check is enabled. [acf53f76](https://github.com/greenbone/openvas-scanner/commit/acf53f76)
* index.md for report-functions [b30aa246](https://github.com/greenbone/openvas-scanner/commit/b30aa246)
* add the nvt after the checks calling the recently added redis_add_nvt(). [ef1e910f](https://github.com/greenbone/openvas-scanner/commit/ef1e910f)
* NASL does not do it as a that just (a = 1) returns [0991e672](https://github.com/greenbone/openvas-scanner/commit/0991e672)
* missing NASL dependency netstat [4e6ff767](https://github.com/greenbone/openvas-scanner/commit/4e6ff767)
* use main_kb to verify scan_id for inconsistencies [11e06e4e](https://github.com/greenbone/openvas-scanner/commit/11e06e4e)
* convert len1 and len2 to size_t, since the function returns a size_ value. Also, convert_string_ntlmssp uses (size_t) -1 as error code, so checking for it as well. [77d15729](https://github.com/greenbone/openvas-scanner/commit/77d15729)
* adjust format with clang-format [6ca43e34](https://github.com/greenbone/openvas-scanner/commit/6ca43e34)
* Multiple bugs reported by the clang static analyzer. [72ef8763](https://github.com/greenbone/openvas-scanner/commit/72ef8763)
* Bug reported by the clang static analyzer. [099487df](https://github.com/greenbone/openvas-scanner/commit/099487df)
* Bug reported by the clang static analyzer. [8e06fe99](https://github.com/greenbone/openvas-scanner/commit/8e06fe99)
* Bug reported by the clang static analyzer. [35f307af](https://github.com/greenbone/openvas-scanner/commit/35f307af)
* Bug reported by the clang static analyzer. [efe513ee](https://github.com/greenbone/openvas-scanner/commit/efe513ee)
* Bug reported by the clang static analyzer. [9dabe7b2](https://github.com/greenbone/openvas-scanner/commit/9dabe7b2)
* Bug reported by the clang static analyzer. [ef2340ba](https://github.com/greenbone/openvas-scanner/commit/ef2340ba)
* Bug reported by the clang static analyzer. [c7b3e9de](https://github.com/greenbone/openvas-scanner/commit/c7b3e9de)
* warning detected via ccc-analyzer. [eaf0b756](https://github.com/greenbone/openvas-scanner/commit/eaf0b756)
* memory leak. Free trace buffer on error [6033cc54](https://github.com/greenbone/openvas-scanner/commit/6033cc54)
* warning detected via ccc-analyzer [4c7a6648](https://github.com/greenbone/openvas-scanner/commit/4c7a6648)
* memory leak detected by ccc-analyzer Free on error. [36bb7525](https://github.com/greenbone/openvas-scanner/commit/36bb7525)
* memory leak Always free name. [69b93de6](https://github.com/greenbone/openvas-scanner/commit/69b93de6)
* memory leak detected via ccc-analyzer Finally free the ipc context. [845380f4](https://github.com/greenbone/openvas-scanner/commit/845380f4)
* warning detected via ccc-analyzer warning: Assigned value is garbage or undefined [815c1a26](https://github.com/greenbone/openvas-scanner/commit/815c1a26)
* null check. It has never closed the child process because a wrong logic. [d145331b](https://github.com/greenbone/openvas-scanner/commit/d145331b)
* warning detected via ccc-analyzer Initialize strutct [58747a95](https://github.com/greenbone/openvas-scanner/commit/58747a95)
* more memory leaks in nasl_snmp.c [8f0be39c](https://github.com/greenbone/openvas-scanner/commit/8f0be39c)
* memory leak. Make a copy of result to be returned as tree_cell and free result. Add destroy_snmp_result() function [44d969e2](https://github.com/greenbone/openvas-scanner/commit/44d969e2)
* more memory leaks found via ccc-analyzer [8b2558ba](https://github.com/greenbone/openvas-scanner/commit/8b2558ba)
* possible memory leak detected via ccc-analyzer Allocate memory later and fix possible memory leak [f9298a02](https://github.com/greenbone/openvas-scanner/commit/f9298a02)
* possible memory leak detected via ccc-analyzer Free `request` on error. [7a312d8a](https://github.com/greenbone/openvas-scanner/commit/7a312d8a)
* possible memory leak detected via ccc-analyzer Move memory allocation inside 'if' block and avoid memory leak [e3fef974](https://github.com/greenbone/openvas-scanner/commit/e3fef974)
* possible memory leak detected via ccc-analyzer Free frame, allocated in forge_frame. Members don't need to be free()'d. [6073025f](https://github.com/greenbone/openvas-scanner/commit/6073025f)
* possible memory leak detected via ccc-analyzer Fix null check [fc35c871](https://github.com/greenbone/openvas-scanner/commit/fc35c871)
* possible memory leak detected via ccc-analyzer Destroy ipc ctx when fork fails. [134ee40b](https://github.com/greenbone/openvas-scanner/commit/134ee40b)
* warning detected via ccc-analyzer [e935e0a1](https://github.com/greenbone/openvas-scanner/commit/e935e0a1)
* warning reported by ccc-analyzer [9009246f](https://github.com/greenbone/openvas-scanner/commit/9009246f)
* memory leaks in ipc_openvas.c [5e1e6129](https://github.com/greenbone/openvas-scanner/commit/5e1e6129)
* Solve warning detected by ccc-analyzer [f55c05ca](https://github.com/greenbone/openvas-scanner/commit/f55c05ca)
* initialize global_max_hosts and global_max_checks from config file (#1210) [2d536948](https://github.com/greenbone/openvas-scanner/commit/2d536948)
* cleanup children pluginlaunch_wait_for_free_process [a9483735](https://github.com/greenbone/openvas-scanner/commit/a9483735)
* Could not fork too many open files [354c42a1](https://github.com/greenbone/openvas-scanner/commit/354c42a1)
* set transport again if falls back in a unecrypted connection (#1190) [c4f5a8c1](https://github.com/greenbone/openvas-scanner/commit/c4f5a8c1)
* duplicate destroy call [4aefb831](https://github.com/greenbone/openvas-scanner/commit/4aefb831)
* change ipc_exec_as_process to use copy instead of pointer [1db7508b](https://github.com/greenbone/openvas-scanner/commit/1db7508b)
* use newdir as a path in message when verification failure (#1182) [476201e4](https://github.com/greenbone/openvas-scanner/commit/476201e4)
* determine SSL/TLS support on services (#1176) [710066d4](https://github.com/greenbone/openvas-scanner/commit/710066d4)
* PLugin process keeps scanning after manually stopping task (#1164) [c080bdd5](https://github.com/greenbone/openvas-scanner/commit/c080bdd5)
* process handler deadlock and signal handler [c9b9e8d6](https://github.com/greenbone/openvas-scanner/commit/c9b9e8d6)
* sync Notus for enterprise feed. (#1150) [39094ec5](https://github.com/greenbone/openvas-scanner/commit/39094ec5)
* openvas-nasl should not exit when forked [1dcb23e0](https://github.com/greenbone/openvas-scanner/commit/1dcb23e0)

[22.4.1]: https://github.com/greenbone/openvas-scanner/compare/v7.0.1.post1...22.4.1