###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_google_chrome_unicode_str_dos_vuln.nasl 3623 2009-07-23 19:16:29Z jul $
#
# Google Chrome Unicode String Denial Of Service Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900805);
  script_version("$Revision: 7922 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2578");
  script_name("Google Chrome Unicode String Denial Of Service Vulnerability");
  desc = "

  Overview: This host is installed with Google Chrome and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  Error occurs when application fails to handle user supplied input into the
  'write' method via a long Unicode string argument.

  Impact:
  Successful exploitation lets the attacker cause memory or CPU consumption,
  resulting in Denial of Service condition.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version 2.x to 2.0.172 on Windows.

  Fix: Upgrade to Google Chrome version 4.1.249.1064 or later.
  For updates refer, http://www.google.com/chrome

  References:
  http://websecurity.com.ua/3338/
  http://www.securityfocus.com/archive/1/archive/1/505092/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

# Check for Google Chrome version 2.x <= 2.0.172
if(version_in_range(version:chromeVer, test_version:"2.0",
                                       test_version2:"2.0.172")){
  security_warning(0);
}
